/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.BaseHireDismissTradeManagerStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageStrategyHint;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.Optional;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class HireDismissTradeManagerStrategy
extends BaseHireDismissTradeManagerStrategy {
    public boolean hireOrFireTradeManager(ICity city, IAIPlayer player) {
        Optional optOffice = player.findTradingOffice(city);
        if (optOffice.isPresent()) {
            ITradingOffice office = (ITradingOffice)optOffice.get();
            if (office.getSteward().isPresent()) {
                return false;
            }
            return player.getHometown().equals(city) || player.getPlayerContext().getHints(city).stream().filter(hint -> hint instanceof CentralStorageStrategyHint).findFirst().isPresent() || !player.findBuildings(city, IWorkShop.class).isEmpty();
        }
        return false;
    }
}

