/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class TransferToShipTradeStep
implements ITradeStep {
    private ICity city;
    private INavigableVessel vessel;
    @MapType(key=IWare.class, value=Integer.class)
    private Map<IWare, Integer> transferableWares;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;

    public boolean execute() {
        IAIPlayer player = (IAIPlayer)this.vessel.getOwner();
        Optional optOffice = player.findTradingOffice(this.city);
        if (optOffice.isPresent()) {
            ITradingOffice office = (ITradingOffice)optOffice.get();
            if (office.getSteward().isPresent()) {
                IAutomatedTrading trading = office.getOfficeTrading();
                this.transferableWares.entrySet().removeIf(entry -> !trading.isMovableToShip((IWare)entry.getKey()));
            }
            this.tradeService.transferFromVesselToStorage(this.vessel, (IPlayer)player, this.city, this.transferableWares);
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String wares = sb.toString();
        this.transferableWares.keySet().stream().forEach(ware -> sb.append(ware).append(", "));
        wares = wares.substring(0, wares.lastIndexOf(","));
        return "TransferToShipTradeStep " + ((IPlayer)this.vessel.getOwner()).getUuid() + "{Transfer " + wares + " to " + this.vessel.getName() + "(" + this.vessel.getUuid() + ") in " + this.city.getName() + "}";
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setTransferableWares(Map<IWare, Integer> transferableWares) {
        this.transferableWares = transferableWares;
    }
}

