/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.sea.BlockadeSeafightContext;
import ch.sahits.game.openpatrician.engine.sea.SeaFightService;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.event.data.ShipBecomesUnavailableEvent;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipNearingPortEvent;
import ch.sahits.game.openpatrician.event.data.ai.BlockadeShipRequestEvent;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IModelTranslationService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ModelFactory;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.city.guild.IShipAuction;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.sea.BlockadeState;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.sea.impl.Blockade;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@DependentInitialisation(value=StartNewGameBean.class)
public class BlockadeEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private BlockadeState blockadeState;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PlayerList players;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private SeaFightService seafightService;
    @Autowired
    private IModelTranslationService modelTranslationService;
    @Autowired
    private MapService mapService;
    @Autowired
    private ModelFactory modelFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.emptyList();
    }

    @PostConstruct
    private void initialize() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void initializeNewBlockade(ICity city) {
        LocalDateTime assemblyDate = this.date.getCurrentDate().plusDays(21L);
        int variance = this.rnd.nextInt(120) - 60;
        LocalDateTime endBlockage = assemblyDate.plusDays(120 + variance);
        Blockade blockade = (Blockade)this.context.getBean("blockade", new Object[]{assemblyDate, endBlockage});
        ICity assemblyPoint = this.mapService.getAldermanCity();
        boolean anyShipRequested = false;
        for (IPlayer player : this.players) {
            int fleetSize = player.getFleet().size();
            int nbShips = Math.min(fleetSize / 10, 3);
            if (nbShips <= 0) continue;
            anyShipRequested = true;
            blockade.requestShip(player, nbShips);
            if (player instanceof IHumanPlayer) {
                String dateAsString = this.modelTranslationService.toDisplayString(assemblyDate);
                DisplayMessage msg = new DisplayMessage(EMessageCategory.OFFICIAL, "ch.sahits.game.openpatrician.engine.sea.BlockadeEngine.blockadeRequest", new Object[]{city.getName(), nbShips, dateAsString, assemblyPoint.getName()});
                TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)player, (Object)msg);
                this.clientServerEventBus.post((Object)targetMsg);
                continue;
            }
            BlockadeShipRequestEvent event = new BlockadeShipRequestEvent(assemblyPoint, nbShips, (IAIPlayer)player);
            this.clientServerEventBus.post((Object)event);
        }
        if (anyShipRequested) {
            this.blockadeState.addBlockade(city, (IBlockade)blockade);
        }
    }

    @Subscribe
    public void handleDailyUpdate(PeriodicalDailyUpdate dayChange) {
        LocalDateTime now = this.date.getCurrentDate();
        for (Map.Entry blockadeEntry : this.blockadeState.entrySet()) {
            IBlockade blockade = (IBlockade)blockadeEntry.getValue();
            ICity blockadeCity = (ICity)blockadeEntry.getKey();
            if (blockade.getAssemblyDate().isBefore(now) && blockade.getBlockadeConvoy() == null) {
                ICity aldermanCity = this.mapService.getAldermanCity();
                List players = blockade.getPlayersWithRequestedShips();
                for (IPlayer player : players) {
                    ArrayList<IShip> ships = new ArrayList<IShip>();
                    int requestedNumber = blockade.getNumberOfRequestedShips(player);
                    for (IShip ship : player.getFleet()) {
                        if (!ship.getLocation().equals((Object)aldermanCity.getCoordinates())) continue;
                        ships.add(ship);
                        if (ships.size() != requestedNumber) continue;
                        break;
                    }
                    if (ships.size() < requestedNumber) {
                        int missingShips = requestedNumber - ships.size();
                        int variance = this.rnd.nextInt(4000) - 1500;
                        int fine = (10000 + variance) * missingShips;
                        if (player instanceof IHumanPlayer) {
                            DisplayMessage msg = new DisplayMessage(EMessageCategory.OFFICIAL, "ch.sahits.game.openpatrician.engine.sea.BlockadeEngine.fineMessage", new Object[]{fine, blockadeCity.getName()});
                            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)msg));
                        }
                        if (player instanceof IHumanPlayer) {
                            player.getCompany().updateCashDirectly((long)(-fine));
                        } else {
                            player.getCompany().updateCashDirectly((long)(-fine));
                        }
                    }
                    if (ships.size() <= 0) continue;
                    blockade.addShips(player, ships);
                }
                if (blockade.getShips().size() > 0) {
                    this.createConvoy(blockade, aldermanCity);
                    IConvoy convoy = blockade.getBlockadeConvoy();
                    this.seafaringService.travelBetweenCities((INavigableVessel)convoy, blockadeCity);
                } else {
                    this.blockadeState.finishBlockade(blockadeCity);
                }
            }
            if (!blockade.getEndBlockade().isBefore(now) || blockade.getBlockadeConvoy() == null || !blockade.getBlockadeConvoy().getLocation().equals((Object)blockadeCity.getCoordinates())) continue;
            ICity returnTo = this.mapService.getAldermanCity();
            this.seafaringService.travelBetweenCities((INavigableVessel)blockade.getBlockadeConvoy(), returnTo);
        }
    }

    @Subscribe
    public void handleShipBreaksBlockade(ShipNearingPortEvent event) {
        ICity city = event.getCity();
        for (Map.Entry entry : this.blockadeState.entrySet()) {
            if (!((ICity)entry.getKey()).equals(city)) continue;
            IConvoy blocadingConvoy = ((IBlockade)entry.getValue()).getBlockadeConvoy();
            INavigableVessel blockadeBreaker = event.getShip();
            BlockadeSeafightContext context = new BlockadeSeafightContext((IBlockade)entry.getValue());
            IPlayer owner = (IPlayer)blockadeBreaker.getOwner();
            owner.updateCrimialDrive(1);
            this.seafightService.calculateOutcome((INavigableVessel)blocadingConvoy, blockadeBreaker, context);
            ((IBlockade)entry.getValue()).getShipsToAuction().addAll(context.getCapturedShips());
        }
    }

    @Subscribe
    public void handleBlockadeConvoyReturns(ShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (vessel instanceof IConvoy) {
            LocalDateTime now = this.date.getCurrentDate();
            ICity aldermanCity = this.mapService.getAldermanCity();
            for (Map.Entry blockadeEntry : this.blockadeState.entrySet()) {
                IConvoy convoy;
                IBlockade blockade = (IBlockade)blockadeEntry.getValue();
                if (!blockade.getEndBlockade().isBefore(now) || !(convoy = blockade.getBlockadeConvoy()).equals(vessel) || !event.getCity().equals(aldermanCity)) continue;
                ICity blockadedCity = (ICity)blockadeEntry.getKey();
                this.dissolveConvoy(blockade, aldermanCity, blockadedCity);
                this.blockadeState.finishBlockade(blockadedCity);
                IGuild guild = (IGuild)this.guildList.findGuild(aldermanCity).get();
                for (IShip ship : blockade.getShipsToAuction()) {
                    LocalDateTime auctionDate = now.plusDays(10L);
                    auctionDate = this.guildService.cleanUpAuctionAndDetermineAuctionDate(auctionDate, guild);
                    IShipAuction auction = this.modelFactory.createAnonymousShipAuction(auctionDate, ship.getValue(), ship);
                    guild.getAuctions().add(auction);
                }
                return;
            }
        }
    }

    void dissolveConvoy(IBlockade blockade, ICity city, ICity blockadedCity) {
        IConvoy convoy = blockade.getBlockadeConvoy();
        for (IShip ship : convoy.getShips()) {
            ship.setAvailable(true);
            IShipOwner owner = ship.getOwner();
            convoy.removeShip(ship);
            ship.parentShipProperty().setValue(null);
            if (owner instanceof IHumanPlayer) {
                DisplayMessage msg = new DisplayMessage(EMessageCategory.OFFICIAL, "ch.sahits.game.openpatrician.engine.sea.BlockadeEngine.blockadesissolve", new Object[]{blockadedCity.getName(), ship.getName(), city.getName()});
                TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)owner, (Object)msg);
                this.clientServerEventBus.post((Object)targetMsg);
            }
            if (owner instanceof IPlayer) {
                IPlayer player = (IPlayer)owner;
                player.addSelectableVessel((INavigableVessel)ship);
            }
            this.clientServerEventBus.post((Object)new ShipEntersPortEvent((INavigableVessel)ship, city));
        }
    }

    void createConvoy(IBlockade blockade, ICity city) {
        List allShips = blockade.getShips();
        IConvoy convoy = this.shipFactory.getConvoy((IShip)allShips.get(0), false);
        for (int i = 1; i < allShips.size(); ++i) {
            IShip ship = (IShip)allShips.get(i);
            convoy.addShip(ship);
            ship.parentShipProperty().setValue((Object)convoy.getOrlegShip());
        }
        for (IShip ship : allShips) {
            ship.setAvailable(false);
            IPlayer owner = (IPlayer)ship.getOwner();
            if (owner instanceof IHumanPlayer) {
                this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)owner, (Object)new ShipBecomesUnavailableEvent(ship, city)));
            }
            owner.removeSelectableVessel((INavigableVessel)ship);
        }
        blockade.setConvoy(convoy);
    }
}

