/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.model.VesselPositionUpdateData;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.IPathConverter;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.sea.AStar;
import ch.sahits.game.openpatrician.engine.sea.model.ShipPositionUpdateTask;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
public class SeafaringService {
    private static final Logger log = LoggerFactory.getLogger(SeafaringService.class);
    @Autowired
    private AStar aStar;
    @Autowired
    @Qualifier(value="clientThreadPool")
    private ExecutorService clientThreadPool;
    @Autowired
    private ShipPositionUpdateTask shipUpdateTask;
    @Autowired
    private ShipService shipService;
    @Autowired
    private IPathConverter pathConverter;
    @Autowired
    @Qualifier(value="schedulableServerThreadPool")
    private ScheduledExecutorService schedulableServerThreadPool;
    @Autowired
    private PathInterpolatorMap interpolators;
    @Autowired
    private IMap map;
    @Autowired
    private MapService mapService;
    @Autowired
    private DialogTemplateFactory dialogTemplateFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    protected AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initializeTimer() {
        this.schedulableServerThreadPool.scheduleAtFixedRate((Runnable)((Object)this.shipUpdateTask), 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public List<Point2D> travelTo(INavigableVessel vessel, Point2D destination) {
        Point2D source;
        Preconditions.checkArgument((boolean)this.shipService.checkNumberOfSailors(vessel), (Object)("The vessel " + vessel.getName() + " (" + vessel.getUuid() + ") has not enough sailors"));
        if (!this.shipService.canReachDestination(vessel, destination)) {
            Preconditions.checkArgument((boolean)false, (Object)("City on a river is not reachable by ship type " + this.shipService.getShipType(vessel)));
        }
        Preconditions.checkArgument((!(source = vessel.getLocation()).equals((Object)destination) ? 1 : 0) != 0, (Object)"Destination and source may not be the same");
        Future<List> future = this.clientThreadPool.submit(() -> this.aStar.findPath(source, destination));
        try {
            if (vessel.getCaptian().isPresent()) {
                ICaptain captain = (ICaptain)vessel.getCaptian().get();
                double distance = source.distance(destination);
                int km = (int)Math.rint(this.mapService.convertToDistenceInKm(distance));
                captain.updatedSailedDistance(km);
                if (captain.upgradeToNextNavigationLevel() && vessel.getOwner() instanceof IHumanPlayer) {
                    DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{captain.getName(), vessel.getName(), captain.getSalary()});
                    DialogTemplate template = this.dialogTemplateFactory.createDialogTemplate(EDialogTemplateType.CAPTAIN_UPGRADE, parameterSupplier);
                    DisplayTemplateMessage message = new DisplayTemplateMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.model.people.impl.CaptainState.captainUpgrade.title", template, new Object[0]);
                    TargetedEvent tagetDisplayMsg = new TargetedEvent((IHumanPlayer)vessel.getOwner(), (Object)message);
                    this.clientServerEventBus.post((Object)tagetDisplayMsg);
                }
            }
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to execute path finding in separate thread from " + source + " to " + destination + " of " + vessel.getName() + " (" + vessel.getUuid() + ") by " + vessel.getOwner().getName() + " " + vessel.getOwner().getLastName() + ".", (Throwable)e);
            return this.aStar.findPath(source, destination);
        }
    }

    public void travelBetweenCities(INavigableVessel vessel, ICity toCity) {
        List<Point2D> path = this.travelTo(vessel, toCity.getCoordinates());
        Preconditions.checkNotNull(path, (Object)("Travel of " + vessel.getName() + "(" + vessel.getUuid() + "): " + vessel.getLocation() + " -> " + toCity.getCoordinates()));
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(true);
        vesselPositionUpdateData.setSourceCity(true);
    }

    public void travelToCity(INavigableVessel vessel, ICity toCity) {
        List<Point2D> path = this.travelTo(vessel, toCity.getCoordinates());
        Preconditions.checkNotNull(path, (Object)("Travel of " + vessel.getName() + "(" + vessel.getUuid() + "): " + vessel.getLocation() + " -> " + toCity.getCoordinates()));
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(true);
        vesselPositionUpdateData.setSourceCity(false);
    }

    public void travelNotBetweenCities(INavigableVessel vessel, Point2D location) {
        List<Point2D> path = this.travelTo(vessel, location);
        Preconditions.checkNotNull(path, (Object)("Travel path for the vessel from " + vessel.getLocation() + " to " + location + " may not be null"));
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(false);
        vesselPositionUpdateData.setSourceCity(false);
    }

    public void travelFromCity(INavigableVessel vessel, Point2D location) {
        List<Point2D> path = this.travelTo(vessel, location);
        Preconditions.checkNotNull(path, (Object)("Travel path for the vessel from " + vessel.getLocation() + " to " + location + " may not be null"));
        this.pathConverter.createPath(vessel, path, 1.0);
        VesselPositionUpdateData vesselPositionUpdateData = this.interpolators.get((Object)vessel);
        vesselPositionUpdateData.setDestinationCity(false);
        vesselPositionUpdateData.setSourceCity(true);
    }
}

