package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.RequiredArgsConstructor;

/**
 * Task that is executed when a weapon construction is finished.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 *         Created on Jul 28, 2017
 */
@RequiredArgsConstructor
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeaponConstructionTask extends TimedTask {

    private final IArmory armory;
    private final EWeapon weapon;

    @Override
    public void run() {
       switch (weapon) {
           case SWORD:
               armory.updateSwordAmount(1);
               break;
           case BALLISTA_BIG:
               armory.updateBallistaBigAmount(1);
               break;
           case BALLISTA_SMALL:
               armory.updateBallistaSmallAmount(1);
               break;
           case BOMBARD:
               armory.updateBombardAmount(1);
               break;
           case BOW:
               armory.updateBowAmount(1);
               break;
           case CANNON:
               armory.updateCanonAmount(1);
               break;
           case CROSSBOW:
               armory.updateCrossbowAmount(1);
               break;
           case HAND_WEAPON:
               armory.updateCutlassAmount(1);
               break;
           case MUSKET:
               armory.updateMusketAmount(1);
               break;
           case TREBUCHET_BIG:
               armory.updateTrebuchetBigAmount(1);
               break;
           case TREBUCHET_SMALL:
               armory.updateTrebuchetSmallAmount(1);
               break;
       }
       armory.gainExperience();
    }

    @Override
    public String toString() {
        return "WeaponConstructionTask{" +
                "UUID=" + getUuid() +
                ", execution at " + getExecutionTime() +
                "weapon=" + weapon +
                '}';
    }
}
