package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;
import lombok.Setter;

/**
 * Trade step to decide weather to hire or fire a trade manager.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 16, 2017
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class HireDismissTradeManagerTradeStep implements ITradeStep {
    @Setter
    @Getter
    private ICity city;
    @Setter
    @Getter
    private IAIPlayer player;

    @Override
    public boolean execute() {
        IAIHireTradeManagerStrategy strategy = player.getHireTradeManagerStrategyType().getStrategy();
        if (strategy.hireOrFireTradeManager(city, player)) {
            strategy.hireOrDismiss(city, player);
        }
        return true;
    }

    @Override
    public String toString() {
        return "HireDismissTradeManagerTradeStep "
                +player.getUuid()+" hire or dismiss trade manager in "
                + city.getName();
    }

}
