package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.javafx.bindings.ConstantIntegerBinding;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleIntegerProperty;
import lombok.Getter;
import lombok.Setter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Implements the sell step for selling a single ware irrelevant of the price.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class SellDumpTradeStep implements ITradeStep {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(SellDumpTradeStep.class);
    @Setter
    private ICity city;
    @Setter
    @Getter
    private IWare ware;
    @Setter
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;

    @Override
    public boolean execute() {
        int availableAmount = city.getWare(ware).getAmount();
        int sellAmount = vessel.getWare(ware).getAmount();
        if (sellAmount > 0) {
            int sellPrice = computablePrice.sellPrice(getWare(), new SimpleIntegerProperty(availableAmount), new ConstantIntegerBinding(sellAmount));
            IAIPlayer player = (IAIPlayer) vessel.getOwner();
            ICompany company = player.getCompany();
            LOGGER.trace("Before: cash={}, in city={}, on ship={}", company.getCash(), city.getWare(ware).getAmount(), vessel.getWare(ware).getAmount());
            company.updateCashDirectly(sellPrice * sellAmount);
            city.move(getWare(), sellAmount, player);
            vessel.load(getWare(), sellAmount, sellPrice);
            LOGGER.trace("Sold {} of {} for a total of: {} ", sellAmount, ware.name(), sellPrice * sellAmount);
            LOGGER.trace("After: cash={}, in city={}, on ship={}", company.getCash(), city.getWare(ware).getAmount(), vessel.getWare(ware).getAmount());
            // TODO ahotz 20.05.2016: handle case where there are ships owned by other players in the convoy
        }
        return true;
    }
    @Override
    public String toString() {
        return "SellDumpTradeStep player "+ ((IPlayer)vessel.getOwner()).getUuid() +" {Sell "
                + getWare() + " for "
                + vessel.getName() + " ("
                + vessel.getUuid() +")in "
                + city.getName() + "}";
    }
}
