package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.Optional;

/**
 * Trade step to transfer selected wares and quantities to the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 23, 2017
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class TransferToShipTradeStep implements ITradeStep {
    @Setter
    private ICity city;

    @Setter
    private INavigableVessel vessel;
    @Setter
    @MapType(key = IWare.class, value = Integer.class)
    private Map<IWare, Integer> transferableWares;
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;

    @Override
    public boolean execute() {
        IAIPlayer player = (IAIPlayer) vessel.getOwner();
        Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
        //noinspection OptionalIsPresent
        if (optOffice.isPresent()) {
            ITradingOffice office = optOffice.get();
            if (office.getSteward().isPresent()) {
                IAutomatedTrading trading = office.getOfficeTrading();
                transferableWares.entrySet().removeIf(entry -> !trading.isMovableToShip(entry.getKey()));
            }
            tradeService.transferFromVesselToStorage(vessel, player, city, transferableWares);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String wares = sb.toString();
        transferableWares.keySet().stream().forEach(ware -> sb.append(ware).append(", "));
        wares = wares.substring(0, wares.lastIndexOf(","));
        return "TransferToShipTradeStep "+ ((IPlayer)vessel.getOwner()).getUuid() +"{Transfer "
                + wares + " to "
                + vessel.getName() + "("
                + vessel.getUuid() + ") in "
                + city.getName() + "}";
    }
}
