package ch.sahits.game.openpatrician.engine.time;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class DailyUpdateTask extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @XStreamOmitField
    private ServerSideTaskFactory taskFactory;
    @Autowired
    @Qualifier("serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initialize() {
        setExecutionTime(getScheduledDateDailyUpdate());
    }

    private LocalDateTime getScheduledDateDailyUpdate() {
        return date.getCurrentDate().plusDays(1);
    }

    private void scheduleNextDayUpdate() {
        taskList.add(taskFactory.getPeriodicalDailyUpdateTask());
    }

    @Override
    public void run() {
        try {
            PeriodicalDailyUpdate evt = new PeriodicalDailyUpdate(date.getCurrentDate());
            clientServerEventBus.post(evt);
        } finally {
            scheduleNextDayUpdate();
        }
    }

    @Override
    public String toString() {
        return "DailyUpdateTask{" +
                "UUID=" + getUuid() +
                ", execution at " + getExecutionTime() +
                "}";
    }
}
