/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ConvoyDisolveEvent;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.DonationRequestState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageFeastRequestState;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.OrlegShipOutfittedEvent;
import ch.sahits.game.openpatrician.clientserverinterface.service.ConvoyService;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapProxy;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.clientserverinterface.service.StrategyHolderService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.AIPlayerEngineState;
import ch.sahits.game.openpatrician.engine.event.EEventState;
import ch.sahits.game.openpatrician.engine.event.EventEngineState;
import ch.sahits.game.openpatrician.engine.event.task.MarriageOfferTask;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.engine.player.AITradeChecker;
import ch.sahits.game.openpatrician.engine.player.CollectConstructionWaresMissionData;
import ch.sahits.game.openpatrician.engine.player.IAIEventHandler;
import ch.sahits.game.openpatrician.engine.player.SupplyCityMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BlockadeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectCelebrationWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.strategy.FormOrJoinConvoyStrategy;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.engine.sea.model.ConvoyRepairMission;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.event.data.BuildingAuctionFinished;
import ch.sahits.game.openpatrician.event.data.BuildingNotAuctioned;
import ch.sahits.game.openpatrician.event.data.GraphInitialisationComplete;
import ch.sahits.game.openpatrician.event.data.ShipAuctionFinished;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipNotAuctioned;
import ch.sahits.game.openpatrician.event.data.ShipyardOrderBuild;
import ch.sahits.game.openpatrician.event.data.ai.BlockadeShipRequestEvent;
import ch.sahits.game.openpatrician.event.data.ai.SpecialMissionFinishedEvent;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.player.AIPlayerContext;
import ch.sahits.game.openpatrician.model.player.ETradeStrategyPreference;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.IBlockadeMission;
import ch.sahits.game.openpatrician.model.product.ISpecialMission;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.sea.BlockadeState;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.IHolk;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.service.DisableProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AIPlayerEngine
extends AbstractEngine
implements IAIEventHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"EVENTS");
    @Autowired
    private AIPlayerList players;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private BlockadeState blockadeState;
    @Autowired
    private BlockadeStrategy blockadeStrategy;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private ShipService shipService;
    @Autowired
    private Date date;
    @Autowired
    private MapService mapService;
    @Autowired
    private TravellingVessels vessels;
    @Autowired
    private AITradeChecker tradeChecker;
    @Autowired
    private ShipyardEngine shipyardEngine;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private StrategyHolderService strategyHolderService;
    @Autowired
    private DisableProperties disableService;
    @Autowired
    private EventEngineState eventState;
    @Autowired
    private AIPlayerEngineState engineState;
    @Autowired
    private MapProxy map;
    @Autowired
    private FormOrJoinConvoyStrategy convoyStrategy;
    @Autowired
    private ConvoyService convoyService;
    @Autowired
    private ApplicationContext context;
    private EGameStatusChange currentGameState = EGameStatusChange.NEW_GAME;
    @ListType(value=ShipEntersPortEvent.class)
    private Queue<ShipEntersPortEvent> shipEntersPortEventQueue = new ConcurrentLinkedQueue<ShipEntersPortEvent>();

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.emptyList();
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
    }

    private void initializeStrategyForVessel(IAIPlayer player, INavigableVessel ship) {
        if (this.initializeConvoy(player, ship)) {
            this.initializeStrategyInternal(player, ship);
        }
    }

    private void initializeStrategyInternal(IAIPlayer player, INavigableVessel ship) {
        IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(ship).getStrategy();
        tradeStrategy.initializeTradeCycle(player, ship);
        player.updateTradeWaitingStatus(ship, false);
        this.initializeWeightedTradeStrategies(player);
    }

    private boolean initializeConvoy(IAIPlayer player, INavigableVessel ship) {
        if (!(ship instanceof IConvoy) && this.convoyStrategy.shouldJoinOrFormConvoy(player)) {
            Optional currentCity = this.shipService.findCity(ship);
            if (currentCity.isPresent()) {
                Optional orleg;
                if (this.convoyStrategy.mustBeFittableForOrleg(ship) && !(orleg = this.convoyService.outfitAsOrleg((IShip)ship, (ICity)currentCity.get())).isPresent()) {
                    log.info("Ship {} ({}) could not be fitted for orleg duties on the spot.", (Object)ship.getName(), (Object)ship.getUuid());
                    return false;
                }
                Optional<IConvoy> convoy = this.convoyStrategy.joinOrFormConvoy((IShip)ship, (ICity)currentCity.get());
                if (convoy.isPresent() && player.getTradeStrategyType((INavigableVessel)convoy.get()) == null) {
                    this.initializeRandomTradeStrategy((INavigableVessel)convoy.get(), player);
                }
            } else {
                log.warn("The ship {} ({}) of {} {} is not in a city when initializing the strategy", new Object[]{ship.getName(), ship.getUuid(), player.getName(), player.getLastName()});
            }
        }
        return true;
    }

    @VisibleForTesting
    void initializeWeightedTradeStrategies(IAIPlayer player) {
        AIPlayerContext context = player.getPlayerContext();
        context.getWeightedStrategies().clear();
        ESocialRank rank = player.getRank();
        if (rank == ESocialRank.COUNCILMAN || rank == ESocialRank.PATRICIAN) {
            context.addWeightedTradeStrategy((IAITradeStrategyType)EAITradeStrategyType.SUPPLY_HOMETOWN);
        }
        if (rank == ESocialRank.MAYOR) {
            context.addWeightedTradeStrategy((IAITradeStrategyType)EAITradeStrategyType.COLLECT_WARES_FOR_STORAGE_LOCATION);
            context.addWeightedTradeStrategy((IAITradeStrategyType)EAITradeStrategyType.DELIVER_WARES_FROM_CENTRAL_STORAGE);
        }
        if (player.getCompany().getCash() < 100000L) {
            context.addWeightedTradeStrategy((IAITradeStrategyType)EAITradeStrategyType.TRADE_ROUTE);
            context.addWeightedTradeStrategy((IAITradeStrategyType)EAITradeStrategyType.PRODUCTION_CHAIN);
        }
    }

    @VisibleForTesting
    List<IAITradeStrategyType> getSelectableTradeStrategy(INavigableVessel vessel, IAIPlayer player) {
        HashMap<Object, Integer> weigthedStrategies = new HashMap<Object, Integer>();
        this.strategyHolderService.getTradeStrategies().stream().forEach(strategyType -> weigthedStrategies.put(strategyType, 1));
        for (Map.Entry entry : player.getPlayerContext().getWeightedStrategies().entrySet()) {
            int i;
            IAITradeStrategyType key = (IAITradeStrategyType)entry.getKey();
            if (key.equals((Object)EAITradeStrategyType.SUPPLY_HOMETOWN) && !this.hasSupplyHomeTownStrategy(player)) {
                for (i = 0; i < (Integer)entry.getValue(); ++i) {
                    weigthedStrategies.put(key, (Integer)weigthedStrategies.get(key) + 1);
                }
            }
            if (key.equals((Object)EAITradeStrategyType.COLLECT_WARES_FOR_STORAGE_LOCATION) && !this.hasFreeCentralStorageCollectionStrategy(player)) {
                for (i = 0; i < (Integer)entry.getValue(); ++i) {
                    weigthedStrategies.put(key, (Integer)weigthedStrategies.get(key) + 1);
                }
            }
            if (!key.equals((Object)EAITradeStrategyType.DELIVER_WARES_FROM_CENTRAL_STORAGE) && !key.equals((Object)EAITradeStrategyType.TRADE_ROUTE) && !key.equals((Object)EAITradeStrategyType.PRODUCTION_CHAIN)) continue;
            for (i = 0; i < (Integer)entry.getValue(); ++i) {
                weigthedStrategies.put(key, (Integer)weigthedStrategies.get(key) + 1);
            }
        }
        for (IAITradeStrategyType type2 : this.strategyHolderService.getTradeStrategies()) {
            for (ETradeStrategyPreference preference : type2.getStrategyPreferrance()) {
                if (!this.isStrategyMatch(vessel, preference)) continue;
                weigthedStrategies.put(type2, (Integer)weigthedStrategies.get(type2) + 1);
            }
        }
        ArrayList<IAITradeStrategyType> tradeStrategyTypes = new ArrayList<IAITradeStrategyType>();
        for (Map.Entry entry : weigthedStrategies.entrySet()) {
            int number = (Integer)entry.getValue();
            for (int i = 0; i < number; ++i) {
                tradeStrategyTypes.add((IAITradeStrategyType)entry.getKey());
            }
        }
        return tradeStrategyTypes.stream().filter(type -> ((IAITradeStrategy)type.getStrategy()).isSelectable(player, vessel)).collect(Collectors.toList());
    }

    private boolean isStrategyMatch(INavigableVessel vessel, ETradeStrategyPreference preference) {
        switch (preference) {
            case COG: {
                return vessel instanceof ICog;
            }
            case CONVOY: {
                return vessel instanceof IConvoy;
            }
            case CRAYER: {
                return vessel instanceof ICrayer;
            }
            case FAST_SHIP: {
                return vessel.getTopSpeed() > 9.0;
            }
            case HEAVY_ARMED: {
                return this.shipService.calculateShipsWeaponsStrength(vessel) > 5;
            }
            case HOLK: {
                return vessel instanceof IHolk;
            }
            case MANY_SAILORS: {
                return vessel.getNumberOfSailors() > vessel.getMinNumberOfSailors() * 2;
            }
            case RIVER_SHIP: {
                return vessel instanceof ICrayer || vessel instanceof ISnaikka;
            }
            case SNAIKKA: {
                return vessel instanceof ISnaikka;
            }
        }
        throw new IllegalArgumentException("Unknown preferrence: " + preference);
    }

    @VisibleForTesting
    boolean hasSupplyHomeTownStrategy(IAIPlayer player) {
        List vessels = player.getSelectableVessels();
        for (INavigableVessel v : vessels) {
            if (!EAITradeStrategyType.SUPPLY_HOMETOWN.equals(player.getTradeStrategyType(v))) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean hasFreeCentralStorageCollectionStrategy(IAIPlayer player) {
        List vessels = player.getSelectableVessels();
        List citiesWithTradingOffice = this.map.getAllCities().stream().filter(city -> player.findTradingOffice(city).isPresent()).collect(Collectors.toList());
        for (INavigableVessel vessel : vessels) {
            if (!EAITradeStrategyType.COLLECT_WARES_FOR_STORAGE_LOCATION.equals(player.getTradeStrategyType(vessel))) continue;
            SupplyCityMissionData missionData = (SupplyCityMissionData)player.getTradeMission(vessel);
            citiesWithTradingOffice.remove(missionData.getTargetCity());
        }
        return !citiesWithTradingOffice.isEmpty();
    }

    @Subscribe
    public void handleBlockadeStart(BlockadeShipRequestEvent event) {
        Optional<IShip> optShip;
        IAIPlayer player = event.getPlayer();
        int requiredShips = event.getNumberOfShips();
        for (int i = 0; i < requiredShips && (optShip = this.blockadeStrategy.selectShip(player)).isPresent(); ++i) {
            IShip vessel = optShip.get();
            player.setTradeMission((INavigableVessel)vessel, (ITradeMissionData)new IBlockadeMission(){});
            this.seafaringService.travelTo((INavigableVessel)vessel, event.getAssemblyCity().getCoordinates());
        }
    }

    @Subscribe
    public void handleShipArrivesInCity(ShipEntersPortEvent event) {
        if (this.shipEntersPortEventQueue != null && !this.shipEntersPortEventQueue.isEmpty()) {
            this.shipEntersPortEventQueue.add(event);
            log.info("Add ShipEntersPortEvent to queue.");
        } else {
            this.handleShipArrival(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleShipArrival(ShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        ICity city = event.getCity();
        if (!vessel.getLocation().equals((Object)city.getCoordinates())) {
            log.warn("The vessel is not in the city, but is moving, this can happen when a new destination is chosen after the ShipPositionUpdate task determined the ship entered the port, but the event was not yet handled.");
            return;
        }
        IShipOwner owner = vessel.getOwner();
        log.debug("Current position of vessel ({} ({})): {}", new Object[]{vessel.getName(), vessel.getUuid(), vessel.getLocation()});
        this.vessels.remove(vessel);
        if (!(owner instanceof IAIPlayer)) return;
        IAIPlayer player = (IAIPlayer)owner;
        IProductionConsumptionKnowledge knowlege = player.getProductionAndConsumptionKnowledge();
        knowlege.updateKnowledge(event.getCity());
        ITradeMissionData missionData = player.getTradeMission(vessel);
        if (missionData instanceof ISpecialMission) {
            if (!(missionData instanceof IBlockadeMission)) throw new IllegalStateException("The special mission " + missionData + " is not implemented");
            this.handleBlockadeMission(vessel, player, event.getCity());
            return;
        }
        player.updateTradeWaitingStatus(vessel, false);
        try {
            IAITradeStrategy strategy = (IAITradeStrategy)player.getTradeStrategyType(vessel).getStrategy();
            this.engineState.activateVesselForTrade(vessel);
            strategy.handleShipArrivesInPort((IShipEntersPortEvent)event);
            return;
        }
        catch (RuntimeException e) {
            log.error("Failed to handle ship arrival of " + vessel.getName() + " (" + vessel.getUuid() + ") of " + player.getName() + " " + player.getLastName(), (Throwable)e);
            return;
        }
        finally {
            this.engineState.deactivateVesselForTrade(vessel);
        }
    }

    @Subscribe
    public void handleGameLoad(GameStateChange gameStateChange) {
        this.currentGameState = gameStateChange.getStatusChange();
        log.info("Changed Game status to {}", (Object)this.currentGameState);
        if (gameStateChange.getStatusChange() == EGameStatusChange.LOAD_GAME_INIT) {
            this.shipEntersPortEventQueue = new ConcurrentLinkedQueue<ShipEntersPortEvent>();
            log.info("Loading of a game was initialized. Queuing further ShipEntersPortEvent.");
        }
    }

    @Subscribe
    public void handleTradeStrategyStart(GraphInitialisationComplete event) {
        if (this.shipEntersPortEventQueue != null) {
            log.info("Handle {} queued ShipEntersPortEvent after graph initialisation", (Object)this.shipEntersPortEventQueue.size());
            while (!this.shipEntersPortEventQueue.isEmpty()) {
                ShipEntersPortEvent shipEntersPortEvent = this.shipEntersPortEventQueue.poll();
                this.handleShipArrival(shipEntersPortEvent);
            }
            this.shipEntersPortEventQueue = null;
        }
        if (this.disableService.aiTradingEnabled() && this.currentGameState != EGameStatusChange.GAME_LOADED) {
            for (IAIPlayer player : this.players) {
                ICity hometown = player.getHometown();
                IProductionConsumptionKnowledge knowlege = player.getProductionAndConsumptionKnowledge();
                knowlege.updateKnowledge(hometown);
                List shipList = player.getFleet();
                for (IShip ship : shipList) {
                    try {
                        if (player.isInitialized((INavigableVessel)ship)) continue;
                        this.initializeStrategyForVessel(player, (INavigableVessel)ship);
                    }
                    catch (RuntimeException e) {
                        log.error("Failed to initialize strategy for ship  " + ship.getName() + " (" + ship.getUuid() + ") of " + player.getName() + " " + player.getLastName(), (Throwable)e);
                    }
                }
                List vesselList = player.getSelectableVessels();
                for (INavigableVessel ship : vesselList) {
                    this.startTradeStrategySteps(player, ship);
                }
            }
        }
    }

    private void startTradeStrategySteps(IAIPlayer player, INavigableVessel ship) {
        IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(ship).getStrategy();
        if (!player.hasMoreTradeSteps(ship)) {
            if (this.shipService.findCity(ship).isPresent()) {
                tradeStrategy.initializeTradeCycle(player, ship);
                log.info("No more tradesteps for vessel {} ({}) of {} {} defined, but located in city: Reinitialize trade strategy", new Object[]{ship.getName(), ship.getUuid(), player.getName(), player.getLastName()});
            } else if (!this.vessels.isTravelling(ship)) {
                ICity nearestCity = tradeStrategy.getCityToRestartTradeCycle(ship);
                this.seafaringService.travelToCity(ship, nearestCity);
                log.warn("No tradesteps defined for vessel {} ({}) of {} {}. Travel to nearest city {}", new Object[]{ship.getName(), ship.getUuid(), player.getName(), player.getLastName(), nearestCity.getName()});
            }
        }
        if (!player.waitingForTradeStepToFinish(ship)) {
            tradeStrategy.executeTradeSteps(player, ship);
        } else {
            log.warn("Skip starting of trade execution as waitingForTradeStepToFinish for {} ({}) of {} {} is {}", new Object[]{ship.getName(), ship.getUuid(), player.getName(), player.getLastName(), player.waitingForTradeStepToFinish(ship)});
        }
    }

    private void handleBlockadeMission(INavigableVessel vessel, IAIPlayer player, ICity city) {
        LocalDateTime now = this.date.getCurrentDate();
        ICity aldermanCity = this.mapService.getAldermanCity();
        if (city.equals(aldermanCity)) {
            if (this.blockadeState.entrySet().isEmpty()) {
                this.initializeStrategyForVessel(player, vessel);
            } else {
                for (Map.Entry entry : this.blockadeState.entrySet()) {
                    IBlockade blockade = (IBlockade)entry.getValue();
                    if (!blockade.getAssemblyDate().isBefore(now)) continue;
                    this.initializeStrategyForVessel(player, vessel);
                }
            }
        } else {
            this.initializeStrategyForVessel(player, vessel);
        }
    }

    public boolean executeCurrentTrade(INavigableVessel vessel) {
        return this.engineState.isActive(vessel);
    }

    @Subscribe
    public void handleWeeklyTasks(PeriodicalTimeWeekEndUpdate event) {
        if (this.disableService.aiTradingEnabled()) {
            for (IAIPlayer player : this.players) {
                List shipList = player.getSelectableVessels();
                for (INavigableVessel vessel : shipList) {
                    if (this.tradeChecker.isEngagedInTrading(vessel) || !this.tradeChecker.shouldBeTrading(vessel)) continue;
                    IAIPlayer owner = (IAIPlayer)vessel.getOwner();
                    log.warn("The vessel {} ({}) of {} {} is currently not trading (position: {}), strategy={}: reinitialize", new Object[]{vessel.getName(), vessel.getUuid(), owner.getName(), owner.getLastName(), vessel.getLocation(), owner.getTradeStrategyType(vessel)});
                    this.clearRemainingTradeSteps(vessel, player);
                    this.initializeStrategyForVessel(player, vessel);
                    IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(vessel).getStrategy();
                    tradeStrategy.executeTradeSteps(player, vessel);
                }
                IAIConstructionSelectionStrategy constructionStategy = (IAIConstructionSelectionStrategy)player.getConstructionSelectionType().getStrategy();
                if (constructionStategy.shouldOrderNewConstruction(player)) {
                    EShipType type = constructionStategy.shouldBuildShipType(player);
                    Optional vessel = constructionStategy.selectCollectingVessel(player, type);
                    vessel.ifPresent(iNavigableVessel -> constructionStategy.initShipConstruction(player, iNavigableVessel, type));
                }
                this.initializeWeightedTradeStrategies(player);
            }
        }
    }

    private void clearRemainingTradeSteps(INavigableVessel vessel, IAIPlayer player) {
        while (player.hasMoreTradeSteps(vessel)) {
            player.getNextTradeStep(vessel);
        }
        player.setTradeMission(vessel, null);
    }

    @Subscribe
    public void handleSpecialMissionFinished(SpecialMissionFinishedEvent event) {
        INavigableVessel vessel = event.getVessel();
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        ICity city = event.getCity();
        log.debug("Special mission for ship {} ({}) of {} {} ended in {}", new Object[]{vessel.getName(), vessel.getUuid(), player.getName(), player.getLastName(), city.getName()});
        ITradeMissionData missionData = event.getMissionData();
        if (missionData instanceof CollectConstructionWaresMissionData) {
            IShipyard shipyard = city.getCityState().getShipyardState();
            ShipyardOrderBuild shipConstructionOrder = new ShipyardOrderBuild(shipyard, ((CollectConstructionWaresMissionData)missionData).getShipType(), (IPlayer)player);
            this.shipyardEngine.handleOrderBuildEvent(shipConstructionOrder);
        }
        if (!player.hasMoreTradeSteps(vessel)) {
            this.initializeRandomTradeStrategy(vessel, player);
            this.initializeStrategyForVessel(player, vessel);
            IAITradeStrategy tradeStrategy = (IAITradeStrategy)player.getTradeStrategyType(vessel).getStrategy();
            tradeStrategy.executeTradeSteps(player, vessel);
        }
    }

    private void initializeRandomTradeStrategy(INavigableVessel vessel, IAIPlayer player) {
        List<IAITradeStrategyType> tradeStrategies = this.getSelectableTradeStrategy(vessel, player);
        player.setTradeStrategyType(vessel, tradeStrategies.get(this.rnd.nextInt(tradeStrategies.size())));
    }

    @Subscribe
    public void handleShipAuctionFinished(ShipAuctionFinished event) {
        IPlayer owner = event.getNewOwner();
        if (owner instanceof IAIPlayer) {
            IShip ship = event.getShip();
            ship.setOwner((IShipOwner)owner);
            owner.addShip(ship);
            this.initializeRandomTradeStrategy((INavigableVessel)ship, (IAIPlayer)owner);
            this.initializeStrategyForVessel((IAIPlayer)owner, (INavigableVessel)ship);
            this.startTradeStrategySteps((IAIPlayer)owner, (INavigableVessel)ship);
        }
    }

    @Subscribe
    public void handleShipNotAuction(ShipNotAuctioned event) {
        IShip ship = event.getShip();
        IPlayer owner = (IPlayer)ship.getOwner();
        if (owner instanceof IAIPlayer) {
            owner.addShip(ship);
            this.initializeRandomTradeStrategy((INavigableVessel)ship, (IAIPlayer)owner);
            this.initializeStrategyForVessel((IAIPlayer)owner, (INavigableVessel)ship);
            this.startTradeStrategySteps((IAIPlayer)owner, (INavigableVessel)ship);
        }
    }

    @Subscribe
    public void handleBuildingAuctionFinished(BuildingAuctionFinished event) {
        if (event.getNewOwner() instanceof IAIPlayer) {
            event.getBuilding().setOwner(event.getNewOwner());
        }
    }

    @Subscribe
    public void handleBuildingNotAuction(BuildingNotAuctioned event) {
    }

    @Override
    public void handleMarriageEvent(IAIPlayer player, MarriageBrokerAnnouncementState state) {
        IAIEventDecisionStrategy strategy = (IAIEventDecisionStrategy)player.getEventDecitionStrategyType().getStrategy();
        if (!player.getSpouseData().isPresent() && strategy.acceptMarriagBrokereOffer(player)) {
            int delay = this.rnd.nextInt(50) + 24;
            LocalDateTime deadLine = state.getDate().plusDays(delay);
            MarriageOfferTask task = this.taskFactory.getMarriageOfferTask(player, state, deadLine);
            log.debug("Add marriage offer task for {} {}", (Object)player.getName(), (Object)player.getLastName());
            this.taskList.add((TimedTask)task);
            this.eventState.setMarriageState((IPlayer)player, EEventState.MARRIAGE_UNDER_CONSIDERATION);
        }
    }

    @Override
    public void handleMarriageWareDelivery(IAIPlayer player, MarriageFeastRequestState state) {
        boolean accept;
        boolean bl = accept = this.rnd.nextBoolean() && player.getFleet().size() > 5;
        if (accept) {
            INavigableVessel nearestVessel = (INavigableVessel)player.getFleet().get(0);
            double minDistance = Double.MAX_VALUE;
            Point2D coord = state.getLocation().getCoordinates();
            for (INavigableVessel vessel : player.getSelectableVessels()) {
                double distance = vessel.getLocation().distance(coord);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                nearestVessel = vessel;
            }
            CollectCelebrationWaresStrategy strategy = (CollectCelebrationWaresStrategy)this.context.getBean(CollectCelebrationWaresStrategy.class);
            strategy.setCelebrationLocation(state.getLocation());
            strategy.initializeTradeCycle(player, nearestVessel);
            player.updateTradeWaitingStatus(nearestVessel, false);
        }
    }

    @Override
    public void handleDonationRequest(IAIPlayer player, DonationRequestState state) {
        boolean accept;
        boolean bl = accept = this.rnd.nextBoolean() && player.getCompany().getCash() > (long)(state.getAmount() * 30);
        if (accept) {
            player.getCompany().updateCashDirectly((long)(-state.getAmount()));
        }
    }

    public void handleShipConstructionFinished(IShip ship, IAIPlayer player) {
        player.addShip(ship);
        this.initializeNewShip(ship, player);
    }

    @Override
    public void initializeNewShip(IShip ship, IAIPlayer player) {
        this.initializeRandomTradeStrategy((INavigableVessel)ship, player);
        this.initializeStrategyForVessel(player, (INavigableVessel)ship);
        this.startTradeStrategySteps(player, (INavigableVessel)ship);
    }

    @Subscribe
    public void handelLoadedNewGame(GameStateChange event) {
        if (event.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            for (IAIPlayer player : this.players) {
                for (IShip ship : player.getFleet()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Trade steps for ship ").append(ship.getName()).append(" (").append(ship.getUuid()).append(") of ").append(player.getName()).append(" ").append(player.getLastName()).append(" after loading:\n");
                    for (ITradeStep tradeStep : player.getTradeSteps((INavigableVessel)ship)) {
                        sb.append(tradeStep).append(" ");
                    }
                    log.info(sb.toString());
                }
            }
        }
    }

    @Subscribe
    public void handleConvoyDissolve(ConvoyDisolveEvent event) {
        IConvoy convoy = event.getConvoy();
        if (convoy.getOwner() instanceof IAIPlayer) {
            IAIPlayer player = (IAIPlayer)convoy.getOwner();
            IShip orleg = convoy.getOrlegShip();
            List<IShip> members = convoy.getShips().stream().filter(ship -> !ship.equals(orleg) && ship.getOwner().equals(player)).collect(Collectors.toList());
            boolean publicConvoy = convoy.isPublicConvoy();
            ConvoyRepairMission tradeMission = new ConvoyRepairMission(orleg, members, publicConvoy);
            player.setTradeMission((INavigableVessel)orleg, (ITradeMissionData)tradeMission);
        }
    }

    @Subscribe
    public void handleShipFittedForOrleg(OrlegShipOutfittedEvent event) {
        IAIPlayer player = (IAIPlayer)event.getShip().getOwner();
        this.initializeStrategyForVessel(player, (INavigableVessel)event.getShip());
    }
}

