/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PostStateDialogToHumanPlayerTask
extends TimedTask {
    private final IDialogState state;
    private final IPlayer player;
    private final String messageKey;
    private final Object[] messageParams;
    private final EMessageCategory category;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public PostStateDialogToHumanPlayerTask(LocalDateTime executionTime, EMessageCategory category, IDialogState state, IPlayer player, String messageKey, Object[] messageParams) {
        this.setExecutionTime(executionTime);
        this.state = state;
        this.player = player;
        this.messageKey = messageKey;
        this.messageParams = messageParams;
        this.category = category;
    }

    public void run() {
        if (this.player instanceof IHumanPlayer) {
            DisplayStateMessage message = new DisplayStateMessage(this.category, this.messageKey, this.state, this.messageParams);
            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.player, (Object)message));
        }
    }

    public String toString() {
        return "PostStateDialogToHumanPlayerTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", player=" + this.player.getUuid() + " " + this.player.getName() + " " + this.player.getLastName() + ", state=" + this.state + ", messageKey='" + this.messageKey + "', category=" + this.category + "}";
    }
}

