/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.TradingOfficeList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.BuildingFinished;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AutomaticTradingEngine
extends AbstractEngine {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private TradingOfficeList offices;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private TradeService tradeService;

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @PostConstruct
    private void initialize() {
        this.clientServerEventBus.register((Object)this);
        this.taskList.add(this.taskFactory.getDailyAIPlayerCheck());
        this.taskList.add(this.taskFactory.getPeriodicalDailyUpdateTask());
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return new ArrayList<AbstractEngine>();
    }

    @Subscribe
    public void handleTradingOfficeBuilt(BuildingFinished event) {
        if (event.getBuilding() instanceof ITradingOffice) {
            ITradingOffice tradingOffice = (ITradingOffice)event.getBuilding();
            this.offices.add(tradingOffice);
            Preconditions.checkArgument((!tradingOffice.getSteward().isPresent() ? 1 : 0) != 0, (Object)"There must not be a stewart assigned.");
        }
    }

    @Subscribe
    public void handleDailyUpdates(PeriodicalDailyUpdate event) {
        for (ITradingOffice office : this.offices) {
            if (!office.getSteward().isPresent()) continue;
            this.sellAndBuy(office);
        }
    }

    @VisibleForTesting
    void sellAndBuy(ITradingOffice office) {
        Preconditions.checkArgument((boolean)office.getSteward().isPresent(), (Object)"Stewart must be present");
        Preconditions.checkNotNull((Object)office.getOfficeTrading(), (Object)"OfficeTrading may not be null");
        IAutomatedTrading automatedTrading = office.getOfficeTrading();
        IBalanceSheet balanceSheet = office.getCurrentWeek();
        for (EWare ware : EWare.values()) {
            ICity city;
            if (automatedTrading.tradingTypeProperty((IWare)ware).get() == ETradeType.CITY_OFFICE) {
                city = office.getCity();
                int maxAmount = automatedTrading.getAmount((IWare)ware);
                int maxPrice = automatedTrading.getPrice((IWare)ware);
                int storedAmount = office.getWare((IWare)ware).getAmount();
                if (maxAmount > storedAmount) {
                    int totalPrice = this.tradeService.buyFromCityToStorage(office, office.getOwner(), city, (IWare)ware, maxAmount, Optional.of(maxPrice), office.getSteward(), 0L);
                    balanceSheet.updateAutomatedTradingCosts((long)totalPrice);
                }
            }
            if (automatedTrading.tradingTypeProperty((IWare)ware).get() != ETradeType.OFFICE_CITY) continue;
            city = office.getCity();
            int avgPrice = automatedTrading.getPrice((IWare)ware);
            int amount = office.getWare((IWare)ware).getAmount() - automatedTrading.getAmount((IWare)ware);
            if (amount <= 0) continue;
            int price = this.tradeService.sellFromStorageToCity(office, office.getOwner(), city, (IWare)ware, amount, Optional.of(avgPrice));
            balanceSheet.updateAutomatedTradingCosts((long)price);
        }
    }
}

