/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.event.task.WeaponConstructionTask;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.WeaponProperties;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.weapon.ArmoryRegistry;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class BlacksmithEngine
extends AbstractEngine {
    private static final EWare[] wares = new EWare[]{EWare.WOOD, EWare.IRON, EWare.LEATHER, EWare.HEMP};
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private ArmoryRegistry armories;
    @Autowired
    private Date date;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private WeaponProperties weaponProperties;

    @PostConstruct
    private void init() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList();
    }

    @Subscribe
    public void handleDailyUpdate(ClockTickDayChange event) {
        for (Map.Entry entry : this.armories) {
            Optional<EWeapon> weaponToProduce;
            IArmory armory = (IArmory)entry.getValue();
            ICity city = (ICity)entry.getKey();
            if (!this.date.getCurrentDate().isAfter(armory.occupiedUntil()) || !(weaponToProduce = this.findWeaponToProduce(armory, city)).isPresent()) continue;
            EWeapon weapon = weaponToProduce.get();
            for (EWare ware : wares) {
                int amount = this.getConstructionAmount(weapon, ware);
                city.move((IWare)ware, -amount, null);
            }
            LocalDateTime finished = this.date.getCurrentDate().plusDays(this.getBuildDuration(weapon));
            armory.occupy(finished);
            WeaponConstructionTask task = this.taskFactory.getWeaponConstructionFinishedTask(armory, weapon);
            task.setExecutionTime(finished);
            this.taskList.add((TimedTask)task);
        }
    }

    @VisibleForTesting
    Optional<EWeapon> findWeaponToProduce(IArmory armory, ICity city) {
        ArrayList producableWeapons = Lists.newArrayList();
        producableWeapons.addAll(Arrays.asList(EWeapon.values()));
        this.filterCapability(producableWeapons, armory.getExperience());
        this.filterWareAvailability(producableWeapons, city);
        this.filterAndSortPriority(producableWeapons, armory);
        this.sortWeaponAvailability(producableWeapons, armory);
        if (producableWeapons.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EWeapon)producableWeapons.get(0));
    }

    private void sortWeaponAvailability(List<EWeapon> producableWeapons, IArmory armory) {
        WeaponAvailabilityComparator comparator = new WeaponAvailabilityComparator(armory);
        producableWeapons.sort(comparator);
    }

    private void filterAndSortPriority(List<EWeapon> producableWeapons, IArmory armory) {
        ArrayList prioWeapons = Lists.newArrayList();
        for (EWeapon weapon : producableWeapons) {
            switch (weapon) {
                case SWORD: {
                    if (!armory.isSwordPriority()) break;
                    prioWeapons.add(weapon);
                    break;
                }
                case BOW: {
                    if (!armory.isBowPriority()) break;
                    prioWeapons.add(weapon);
                    break;
                }
                case CROSSBOW: {
                    if (!armory.isCrossbowPriority()) break;
                    prioWeapons.add(weapon);
                    break;
                }
                case MUSKET: {
                    if (!armory.isMusketPriority()) break;
                    prioWeapons.add(weapon);
                }
            }
        }
        if (!prioWeapons.isEmpty()) {
            producableWeapons.clear();
            producableWeapons.addAll(prioWeapons);
        }
    }

    private void filterWareAvailability(List<EWeapon> producableWeapons, ICity city) {
        Iterator<EWeapon> iterator = producableWeapons.iterator();
        while (iterator.hasNext()) {
            EWeapon weapon = iterator.next();
            boolean remove = false;
            for (EWare ware : wares) {
                int requiredAmount = this.getConstructionAmount(weapon, ware);
                if (city.getWare((IWare)ware).getAmount() >= requiredAmount) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            iterator.remove();
        }
    }

    private void filterCapability(List<EWeapon> producableWeapons, double experience) {
        producableWeapons.removeIf(weapon -> experience < this.getMinExperience((EWeapon)weapon));
    }

    private double getMinExperience(EWeapon weapon) {
        switch (weapon) {
            case BALLISTA_BIG: {
                return this.weaponProperties.getBallistaBig().getMinExperiance();
            }
            case BALLISTA_SMALL: {
                return this.weaponProperties.getBallistaSmall().getMinExperiance();
            }
            case BOMBARD: {
                return this.weaponProperties.getBombard().getMinExperiance();
            }
            case BOW: {
                return this.weaponProperties.getBow().getMinExperiance();
            }
            case CANNON: {
                return this.weaponProperties.getCanon().getMinExperiance();
            }
            case CROSSBOW: {
                return this.weaponProperties.getCrossbow().getMinExperiance();
            }
            case HAND_WEAPON: {
                return this.weaponProperties.getCutlass().getMinExperiance();
            }
            case MUSKET: {
                return this.weaponProperties.getMusket().getMinExperiance();
            }
            case SWORD: {
                return this.weaponProperties.getSword().getMinExperiance();
            }
            case TREBUCHET_BIG: {
                return this.weaponProperties.getTrebuchetBig().getMinExperiance();
            }
            case TREBUCHET_SMALL: {
                return this.weaponProperties.getTrebuchetSmall().getMinExperiance();
            }
        }
        return Double.MAX_VALUE;
    }

    private int getConstructionAmount(EWeapon weapon, EWare ware) {
        switch (weapon) {
            case BALLISTA_BIG: {
                return (int)Math.rint((double)this.getConstructionAmount(EWeapon.BALLISTA_SMALL, ware) * 1.5);
            }
            case BALLISTA_SMALL: {
                switch (ware) {
                    case WOOD: {
                        return 4;
                    }
                    case LEATHER: {
                        return 3;
                    }
                    case IRON: {
                        return 10;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case BOMBARD: {
                switch (ware) {
                    case WOOD: {
                        return 3;
                    }
                    case LEATHER: {
                        return 2;
                    }
                    case IRON: {
                        return 15;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case BOW: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 1;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case CANNON: {
                switch (ware) {
                    case WOOD: {
                        return 3;
                    }
                    case LEATHER: {
                        return 2;
                    }
                    case IRON: {
                        return 20;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case CROSSBOW: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 2;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case HAND_WEAPON: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 1;
                    }
                    case HEMP: {
                        return 0;
                    }
                }
                return 0;
            }
            case MUSKET: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 5;
                    }
                    case HEMP: {
                        return 0;
                    }
                }
                return 0;
            }
            case SWORD: {
                switch (ware) {
                    case WOOD: {
                        return 0;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 2;
                    }
                    case HEMP: {
                        return 0;
                    }
                }
                return 0;
            }
            case TREBUCHET_BIG: {
                return (int)Math.rint((double)this.getConstructionAmount(EWeapon.TREBUCHET_SMALL, ware) * 1.5);
            }
            case TREBUCHET_SMALL: {
                switch (ware) {
                    case WOOD: {
                        return 3;
                    }
                    case LEATHER: {
                        return 5;
                    }
                    case IRON: {
                        return 8;
                    }
                    case HEMP: {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    private int getBuildDuration(EWeapon weapon) {
        switch (weapon) {
            case SWORD: {
                return this.weaponProperties.getSword().getDuration();
            }
            case BALLISTA_BIG: {
                return this.weaponProperties.getBallistaBig().getDuration();
            }
            case BALLISTA_SMALL: {
                return this.weaponProperties.getBallistaSmall().getDuration();
            }
            case BOMBARD: {
                return this.weaponProperties.getBombard().getDuration();
            }
            case BOW: {
                return this.weaponProperties.getBow().getDuration();
            }
            case CANNON: {
                return this.weaponProperties.getCanon().getDuration();
            }
            case CROSSBOW: {
                return this.weaponProperties.getCrossbow().getDuration();
            }
            case HAND_WEAPON: {
                return this.weaponProperties.getCutlass().getDuration();
            }
            case MUSKET: {
                return this.weaponProperties.getMusket().getDuration();
            }
            case TREBUCHET_BIG: {
                return this.weaponProperties.getTrebuchetBig().getDuration();
            }
            case TREBUCHET_SMALL: {
                return this.weaponProperties.getTrebuchetSmall().getDuration();
            }
        }
        return 0;
    }

    private static class WeaponAvailabilityComparator
    implements Comparator<EWeapon> {
        private final IArmory armory;

        public WeaponAvailabilityComparator(IArmory armory) {
            this.armory = armory;
        }

        @Override
        public int compare(EWeapon w1, EWeapon w2) {
            return this.getAmount(w1) - this.getAmount(w2);
        }

        private int getAmount(EWeapon weapon) {
            switch (weapon) {
                case SWORD: {
                    return this.armory.swordAmountProperty().get();
                }
                case BALLISTA_BIG: {
                    return this.armory.ballistaBigAmountProperty().get();
                }
                case BALLISTA_SMALL: {
                    return this.armory.ballistaSmallAmountProperty().get();
                }
                case BOMBARD: {
                    return this.armory.bombardAmountProperty().get();
                }
                case BOW: {
                    return this.armory.bowAmountProperty().get();
                }
                case CANNON: {
                    return this.armory.canonAmountProperty().get();
                }
                case CROSSBOW: {
                    return this.armory.crossbowAmountProperty().get();
                }
                case HAND_WEAPON: {
                    return this.armory.cutlassAmountProperty().get();
                }
                case MUSKET: {
                    return this.armory.musketAmountProperty().get();
                }
                case TREBUCHET_BIG: {
                    return this.armory.trebuchetBigAmountProperty().get();
                }
                case TREBUCHET_SMALL: {
                    return this.armory.trebuchetSmallAmountProperty().get();
                }
            }
            return 0;
        }
    }
}

