/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.event.data.PeriodicalDailyUpdate;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.GameFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.CityProductionAndConsumptionService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.land.city.AutomaticTradingEngine;
import ch.sahits.game.openpatrician.engine.land.city.BlacksmithEngine;
import ch.sahits.game.openpatrician.engine.land.city.ChurchEngine;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.engine.land.city.GuildEngine;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.engine.land.city.TavernEngine;
import ch.sahits.game.openpatrician.engine.player.PlayerEngine;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipLeavingPort;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.city.CityProductionStorage;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.PopulationUpdateStats;
import ch.sahits.game.openpatrician.model.event.FoundingCityBecomesAccessible;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.initialisation.MapInitializedBean;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=MapInitializedBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CityEngine
extends AbstractEngine {
    @Autowired
    private ShipyardEngine shipyardEngine;
    @Autowired
    private TimedUpdatableTaskList taskList;
    private static final int WARE_UPDATES_MINUTES = 720;
    private int numberOfTicks;
    private int tickCounter = 0;
    private static final byte STOPPED = 0;
    private static final byte STARTED = 1;
    private byte state = 0;
    @Autowired
    private Date date;
    @Autowired
    private CitiesState citiesState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    @Qualifier(value="javaFXApplicationThreadExecution")
    private IJavaFXApplicationThreadExecution threadExecutor;
    @Autowired
    private CityProductionAndConsumptionService productionAndConsumtionService;
    @Autowired
    private PopulationConsume consume;
    @Autowired
    private AutomaticTradingEngine automaticTradingEngine;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private PlayerEngine playerEngine;
    @Autowired
    private ChurchEngine churchEngine;
    @Autowired
    private TavernEngine tavernEngine;
    @Autowired
    private GuildEngine guildEngine;
    @Autowired
    private BlacksmithEngine blacksmithEngine;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private CityProductionStorage cityProductionStorage;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private Random rnd;

    @PostConstruct
    public void initialize() {
        this.numberOfTicks = 720 / this.date.getTickUpdate();
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
        this.taskList.add(this.taskFactory.getWeeklyCityCheck());
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleClockTickIntervallChange(ClockTickIntervalChange event) {
        this.numberOfTicks = event.getInterval() == 0 ? -1 : 720 / event.getInterval();
    }

    int getNumberOfTicks() {
        return this.numberOfTicks;
    }

    @Subscribe
    public void handleClockTicked(ClockTick event) {
        ++this.tickCounter;
        if (this.tickCounter == this.numberOfTicks && this.state == 1) {
            this.tickCounter = 0;
            this.threadExecutor.execute(this::consumeWares);
        }
    }

    private void consumeWares() {
        for (CityState state : this.citiesState.getCityEngineStates()) {
            this.productionAndConsumtionService.consumeWares(state);
        }
    }

    private void addCity(ICity city) {
        CityState cityState = city.getCityState();
        this.tavernEngine.addCity(cityState.getTavernState(), city);
        this.loanerEngine.addNewLoaner(city);
        this.cityHallEngine.establishCityHall(city);
        this.churchEngine.establishChurch(city);
        this.guildEngine.establishGuild(city);
    }

    public void start(IGame game) {
        for (ICity city : game.getMap().getCities()) {
            CityState cityState = this.gameFactory.getCityState(city);
            city.setCityState(cityState);
            this.addCity(city);
        }
        this.citiesState.init();
        this.state = 1;
    }

    @Override
    public List<AbstractEngine> getChildren() {
        ArrayList engines = Lists.newArrayList();
        engines.add(this.tavernEngine);
        engines.add(this.shipyardEngine);
        engines.add(this.automaticTradingEngine);
        engines.add(this.loanerEngine);
        engines.add(this.cityHallEngine);
        engines.add(this.playerEngine);
        engines.add(this.churchEngine);
        engines.add(this.guildEngine);
        engines.add(this.blacksmithEngine);
        return engines;
    }

    public ShipyardEngine getShipyardEngine() {
        return this.shipyardEngine;
    }

    public TavernEngine findTavernEngine() {
        return this.tavernEngine;
    }

    @Subscribe
    public void handleCityAdd(FoundingCityBecomesAccessible event) {
        ICity city = event.getCity();
        this.addCity(city);
        CityState cityState = this.gameFactory.getCityState(city);
        this.citiesState.addCity(city, cityState);
        this.cityProductionStorage.add(city);
    }

    @Subscribe
    public void handleShipArrival(ShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        ICity city = event.getCity();
        city.getCityState().getPopUpdateStatistic().arrives(vessel);
    }

    @Subscribe
    public void handleShipDeparture(ShipLeavingPort event) {
        INavigableVessel vessel = event.getShip();
        ICity city = event.getCity();
        city.getCityState().getPopUpdateStatistic().depart(vessel);
    }

    @Subscribe
    public void handleDailyUpdate(PeriodicalDailyUpdate event) {
        for (CityState cityState : this.citiesState.getCityEngineStates()) {
            this.handlePopulationUpdate(cityState);
        }
    }

    private void handlePopulationUpdate(CityState cityState) {
        int nbBeggars = 0;
        PopulationUpdateStats stats = cityState.getPopUpdateStatistic();
        if (stats.isFeedThePoor()) {
            nbBeggars = 20 + this.rnd.nextInt(30);
        } else {
            int nbHiredSailors = stats.getNbHiredSailors();
            if (nbHiredSailors > 0) {
                nbBeggars = this.rnd.nextInt((int)((double)nbHiredSailors * 1.5));
            }
        }
        ICity city = cityState.getCity();
        if (nbBeggars > 0) {
            city.setPopulation(city.getPopulation(EPopulationClass.BEGGAR) + nbBeggars, EPopulationClass.BEGGAR);
        }
        if (stats.getHiredWorkers() > 0) {
            int amount = stats.getHiredWorkers();
            city.setPopulation(city.getPopulation(EPopulationClass.BEGGAR) - amount, EPopulationClass.BEGGAR);
            city.setPopulation(city.getPopulation(EPopulationClass.POOR) + amount, EPopulationClass.POOR);
        }
        boolean allWareAvailable = true;
        for (EWare ware : EWare.values()) {
            double requiredAmount = this.consume.getNeed((IWare)ware, EPopulationClass.POOR, city.getPopulation(EPopulationClass.POOR));
            if (!((double)city.getWare((IWare)ware).getAmount() < requiredAmount)) continue;
            allWareAvailable = false;
            break;
        }
        if (allWareAvailable && this.rnd.nextInt(5) == 0) {
            city.setPopulation(city.getPopulation(EPopulationClass.POOR) - 1, EPopulationClass.POOR);
            city.setPopulation(city.getPopulation(EPopulationClass.MEDIUM) + 1, EPopulationClass.MEDIUM);
        }
        if (stats.getArrivedShips().size() >= 10 && stats.getDepartedShips().size() >= 10 && this.rnd.nextInt(10) == 0) {
            city.setPopulation(city.getPopulation(EPopulationClass.MEDIUM) - 1, EPopulationClass.MEDIUM);
            city.setPopulation(city.getPopulation(EPopulationClass.RICH) + 1, EPopulationClass.RICH);
        }
        stats.reset();
    }
}

