/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.AldermanOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import java.util.Optional;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class AddViolationTask
extends TimedTask {
    private final ICityViolation violation;
    private final IAldermanOffice office;

    public AddViolationTask(ICityViolation violation, IAldermanOffice office, LocalDateTime electionTime) {
        this.violation = violation;
        this.office = office;
        this.setExecutionTime(electionTime);
    }

    public void run() {
        if (!this.office.getViolation().isPresent()) {
            ((AldermanOffice)this.office).setViolation(Optional.of(this.violation));
        }
    }

    public String toString() {
        return "AddViolationTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", violation=" + this.violation + "}";
    }
}

