/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.clientserverinterface.service.PlayerProductionService;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.player.TradeManagerService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class DailyPlayerUpdater
extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private PlayerList players;
    @Autowired
    private IMap map;
    @Autowired
    @XStreamOmitField
    private ServerSideTaskFactory taskFactory;
    @Autowired
    @XStreamOmitField
    private TradeManagerService tradeManagerService;
    @Autowired
    @XStreamOmitField
    private PlayerProductionService playerProductionService;

    @PostConstruct
    private void initialize() {
        this.setExecutionTime(this.getScheduledDateDailyUpdate());
    }

    private LocalDateTime getScheduledDateDailyUpdate() {
        return this.date.getCurrentDate().plusDays(1L);
    }

    public void run() {
        this.handleDailyUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDailyUpdates() {
        try {
            for (IPlayer player : this.players) {
                List<ITradingOffice> offices = this.findTradingOddices(player);
                if (player instanceof IAIPlayer) {
                    this.handleTradingOfficeUpdates(offices);
                }
                this.handleWorkshopConsumptionAndProduction(offices);
            }
        }
        finally {
            this.scheduleNextDayUpdate();
        }
    }

    private void handleWorkshopConsumptionAndProduction(List<ITradingOffice> offices) {
        offices.parallelStream().forEach(office -> {
            this.playerProductionService.produceWares(office);
            this.playerProductionService.buyWareForProductionOneDay(office);
        });
    }

    private List<ITradingOffice> findTradingOddices(IPlayer player) {
        return this.map.getCities().stream().map(arg_0 -> ((IPlayer)player).findTradingOffice(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private void handleTradingOfficeUpdates(List<ITradingOffice> offices) {
        offices.parallelStream().filter(office -> office.getSteward().isPresent()).forEach(office -> this.tradeManagerService.setupOrUpdateAutomaticTrading((ITradingOffice)office));
    }

    private void scheduleNextDayUpdate() {
        this.taskList.add(this.taskFactory.getDailyAIPlayerCheck());
    }

    public String toString() {
        return "DailyPlayerUpdater{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + "}";
    }
}

