/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageDeliveryTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CheapProductionTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.DynamicTradeRouteStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.ProductionChainTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.SupplyCentralTradingStationAIStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.SupplyHometownAIStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.TradeRouteTradeStrategy;
import ch.sahits.game.openpatrician.model.player.ETradeStrategyPreference;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public enum EAITradeStrategyType implements IAITradeStrategyType
{
    CHEAP_PRODUCTION(CheapProductionTradeStrategy.class, new ETradeStrategyPreference[0]),
    TRADE_ROUTE(TradeRouteTradeStrategy.class, ETradeStrategyPreference.FAST_SHIP),
    DYNAMIC_TRADE_ROUTE(DynamicTradeRouteStrategy.class, ETradeStrategyPreference.FAST_SHIP),
    PRODUCTION_CHAIN(ProductionChainTradeStrategy.class, new ETradeStrategyPreference[0]),
    SUPPLY_HOMETOWN(SupplyHometownAIStrategy.class, ETradeStrategyPreference.CONVOY, ETradeStrategyPreference.HOLK),
    COLLECT_WARES_FOR_STORAGE_LOCATION(SupplyCentralTradingStationAIStrategy.class, ETradeStrategyPreference.CONVOY),
    DELIVER_WARES_FROM_CENTRAL_STORAGE(CentralStorageDeliveryTradeStrategy.class, ETradeStrategyPreference.CONVOY),
    COLLECT_WARES(CollectionWaresStrategy.class, ETradeStrategyPreference.FAST_SHIP);

    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAITradeStrategy> strategyClass;
    private final Set<ETradeStrategyPreference> preferance;

    private EAITradeStrategyType(Class<? extends IAITradeStrategy> strategyClass, ETradeStrategyPreference ... prefs) {
        this.strategyClass = strategyClass;
        this.preferance = new HashSet<ETradeStrategyPreference>();
        for (ETradeStrategyPreference pref : prefs) {
            this.preferance.add(pref);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public IAITradeStrategy getStrategy() {
        return (IAITradeStrategy)this.context.getBean(this.strategyClass);
    }

    public Set<ETradeStrategyPreference> getStrategyPreferrance() {
        return this.preferance;
    }
}

