/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.model.WaitingTradeMissionWrapper;
import ch.sahits.game.openpatrician.clientserverinterface.model.WeaponSlotCount;
import ch.sahits.game.openpatrician.clientserverinterface.service.ConvoyService;
import ch.sahits.game.openpatrician.clientserverinterface.service.OutriggerService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.event.task.WaitForShipArrival;
import ch.sahits.game.openpatrician.engine.sea.DangerService;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivity;
import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.ship.ConvoyList;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class FormOrJoinConvoyStrategy {
    @Autowired
    private DangerService dangerService;
    @Autowired
    private PirateActivity pirateActivity;
    @Autowired
    private ConvoyList convoyList;
    @Autowired
    private ShipService shipService;
    @Autowired
    private OutriggerService outriggerService;
    @Autowired
    private ConvoyService convoyService;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private SeafaringService seafaringService;

    private boolean isDangerous() {
        int limitNumberOfFewAttacks;
        List<PirateActivityEntry> attacks = this.pirateActivity.getPirateActivity();
        int numberOfAttacks = this.dangerService.getNumberOfSuccessfulPirateAttacks(attacks);
        return numberOfAttacks > (limitNumberOfFewAttacks = this.pirateActivity.getObservationPeriodInDays() / 14);
    }

    private boolean hasSmallFleet(IAIPlayer player) {
        return this.getShipCount(player) < 5L;
    }

    private long getShipCount(IAIPlayer player) {
        return player.getFleet().stream().filter(ship -> ship.parentShipProperty().get() == null || ship.equals(ship.parentShipProperty().get())).count();
    }

    private boolean hasMediumFleet(IAIPlayer player) {
        long shipCount = this.getShipCount(player);
        return shipCount >= 5L && shipCount <= 20L;
    }

    private boolean hasLargeFleet(IAIPlayer player) {
        long shipCount = this.getShipCount(player);
        return shipCount > 20L;
    }

    private Optional<IConvoy> getNonCopingConvoy(IAIPlayer player) {
        for (IConvoy convoy : this.convoyList) {
            int loadedSpace;
            int freeSpace;
            int capacity;
            if (!convoy.getOwner().equals(player) || !((double)(capacity = convoy.getLoadableSpace()) * 0.1 <= (double)(freeSpace = capacity - (loadedSpace = convoy.getLoadBinding().get())))) continue;
            return Optional.of(convoy);
        }
        return Optional.empty();
    }

    private Optional<INavigableVessel> findStrategyNotCoping(IAIPlayer player, IShip vessel) {
        for (IShip ship : player.getFleet()) {
            int loadedSpace;
            int freeSpace;
            int capacity;
            IAITradeStrategyType strategy;
            if (ship.equals(vessel) || (strategy = player.getTradeStrategyType((INavigableVessel)ship)) == null || !((double)(capacity = ship.getLoadableSpace()) * 0.1 <= (double)(freeSpace = capacity - (loadedSpace = ship.getLoadBinding().get())))) continue;
            return Optional.of(ship);
        }
        return Optional.empty();
    }

    private boolean canBeFittedToOrleg(IShip vessel, ICity city) {
        WeaponSlotCount weaponSlotCount;
        int weaponSlots;
        if (vessel instanceof ISnaikka) {
            return false;
        }
        int requiredStrength = this.outriggerService.getRequiredWeaponStrength(city);
        if (requiredStrength <= (weaponSlots = (weaponSlotCount = this.shipService.getWeaponSlotCount(vessel.getWeaponSlots())).getNbLargeSlots() + 2 * weaponSlotCount.getNbLargeSlots())) {
            int sailorOccupiedSpace = 10;
            int upgradeReduction = vessel.getUpgradeSpaceReduction();
            int actualStrength = this.shipService.calculateShipsWeaponsStrength((INavigableVessel)vessel);
            int weaponSpaceRequired = vessel.getOccupiedSpaceByWeapons() + Math.max(requiredStrength - actualStrength, actualStrength);
            int targetOccupiedSpace = sailorOccupiedSpace + upgradeReduction + weaponSpaceRequired;
            if (targetOccupiedSpace < vessel.getSize() / 2) {
                return true;
            }
        }
        return false;
    }

    private Optional<IConvoy> isConvoyInCity(ICity city) {
        for (IConvoy convoy : this.convoyList) {
            Optional destination = this.shipService.getDestinationCity((INavigableVessel)convoy);
            if (!destination.isPresent() || !((ICity)destination.get()).equals(city)) continue;
            return Optional.of(convoy);
        }
        return Optional.empty();
    }

    public boolean mustBeFittableForOrleg(INavigableVessel vessel) {
        if (vessel instanceof IShip) {
            return !this.findVesselWithNotCopingStrategy((IShip)vessel, (IAIPlayer)vessel.getOwner()).isPresent();
        }
        return false;
    }

    public Optional<IConvoy> joinOrFormConvoy(IShip vessel, ICity city) {
        IAIPlayer player = (IAIPlayer)vessel.getOwner();
        Optional<? extends INavigableVessel> strategyNotCoping = this.findVesselWithNotCopingStrategy(vessel, player);
        Optional<IConvoy> convoyInCity = this.isConvoyInCity(city);
        IAIPlayer owner = (IAIPlayer)vessel.getOwner();
        if (strategyNotCoping.isPresent()) {
            ICity convoyNextDestination = (ICity)this.shipService.getDestinationCity(strategyNotCoping.get()).get();
            boolean waitingShipAtDestination = convoyNextDestination.equals(city);
            boolean waitedOnShipInCity = strategyNotCoping.get().getLocation().equals((Object)city.getCoordinates());
            if (strategyNotCoping.get() instanceof IConvoy) {
                IConvoy convoy = (IConvoy)strategyNotCoping.get();
                if (waitedOnShipInCity) {
                    this.convoyService.join(convoy, vessel);
                } else {
                    Runnable completionAction = () -> {
                        this.convoyService.join(convoy, vessel);
                        owner.setTradeMission((INavigableVessel)vessel, null);
                        ITradeMissionData blockingConvoyMission = player.getTradeMission((INavigableVessel)convoy);
                        if (blockingConvoyMission instanceof WaitingTradeMissionWrapper) {
                            player.setTradeMission((INavigableVessel)convoy, ((WaitingTradeMissionWrapper)blockingConvoyMission).getTradeMissionData());
                        }
                    };
                    WaitForShipArrival task = this.taskFactory.waitForShipArrival((INavigableVessel)vessel, (INavigableVessel)convoy, convoyNextDestination, completionAction, waitingShipAtDestination);
                    owner.setTradeMission((INavigableVessel)vessel, (ITradeMissionData)task);
                    if (!waitingShipAtDestination) {
                        this.seafaringService.travelBetweenCities((INavigableVessel)vessel, convoyNextDestination);
                    }
                    WaitingTradeMissionWrapper blockingMission = new WaitingTradeMissionWrapper(player.getTradeMission((INavigableVessel)convoy));
                    player.setTradeMission((INavigableVessel)convoy, (ITradeMissionData)blockingMission);
                }
                return Optional.of(convoy);
            }
            IConvoy convoy = this.convoyService.create(vessel, false);
            IShip ship = (IShip)strategyNotCoping.get();
            Runnable completionAction = () -> {
                this.convoyService.join(convoy, ship);
                ITradeMissionData blockingConvoyMission = player.getTradeMission((INavigableVessel)ship);
                if (blockingConvoyMission instanceof WaitingTradeMissionWrapper) {
                    player.setTradeMission((INavigableVessel)convoy, ((WaitingTradeMissionWrapper)blockingConvoyMission).getTradeMissionData());
                }
                owner.setTradeMission((INavigableVessel)ship, null);
            };
            WaitForShipArrival task = this.taskFactory.waitForShipArrival((INavigableVessel)convoy, (INavigableVessel)ship, convoyNextDestination, completionAction, waitingShipAtDestination);
            owner.setTradeMission((INavigableVessel)convoy, (ITradeMissionData)task);
            owner.setTradeStrategyType((INavigableVessel)convoy, owner.getTradeStrategyType((INavigableVessel)ship));
            if (!city.equals(convoyNextDestination)) {
                this.seafaringService.travelBetweenCities((INavigableVessel)convoy, convoyNextDestination);
            }
            WaitingTradeMissionWrapper blockingMission = new WaitingTradeMissionWrapper(player.getTradeMission((INavigableVessel)ship));
            player.setTradeMission(strategyNotCoping.get(), (ITradeMissionData)blockingMission);
            return Optional.of(convoy);
        }
        if ((this.hasMediumFleet(player) && !this.hasSmallFleet(player) || this.hasLargeFleet(player)) && this.canBeFittedToOrleg(vessel, city)) {
            boolean publicConvoy = !this.hasLargeFleet(player);
            return Optional.of(this.convoyService.create(vessel, publicConvoy));
        }
        if (convoyInCity.isPresent()) {
            IConvoy convoy = convoyInCity.get();
            if (convoy.getLocation().equals((Object)city.getCoordinates())) {
                this.convoyService.join(convoy, vessel);
            } else {
                Runnable completionAction = () -> {
                    this.convoyService.join(convoy, vessel);
                    owner.setTradeMission((INavigableVessel)vessel, null);
                };
                WaitForShipArrival task = this.taskFactory.waitForShipArrival((INavigableVessel)vessel, (INavigableVessel)convoy, city, completionAction, true);
                owner.setTradeMission((INavigableVessel)vessel, (ITradeMissionData)task);
            }
            return Optional.of(convoy);
        }
        return Optional.empty();
    }

    private Optional<? extends INavigableVessel> findVesselWithNotCopingStrategy(IShip vessel, IAIPlayer player) {
        Optional<IConvoy> strategyNotCoping = this.getNonCopingConvoy(player);
        if (!strategyNotCoping.isPresent()) {
            strategyNotCoping = this.findStrategyNotCoping(player, vessel);
        }
        return strategyNotCoping;
    }

    public boolean shouldJoinOrFormConvoy(IAIPlayer player) {
        return this.isDangerous() && this.hasSmallFleet(player) || this.getNonCopingConvoy(player).isPresent();
    }
}

