/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseBuyTradeStep
implements ITradeStep {
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;
    private ICity city;
    private IWare ware;
    private INavigableVessel vessel;
    private int maxBuyPrice;
    private long retainCash = 0L;

    protected long transferFromOfficeOrBuyFromCity(IPlayer player, int maxAmount) {
        ITradingOffice office;
        Optional optOffice = player.findTradingOffice(this.city);
        if (optOffice.isPresent() && ((ITradingOffice)optOffice.get()).getSteward().isPresent() && (office = (ITradingOffice)optOffice.get()).getOfficeTrading().isMovableToShip(this.ware)) {
            int loaded = this.tradeService.transferFromStorageToVessel(office, this.vessel, player, this.ware, maxAmount);
            maxAmount -= loaded;
        }
        if (maxAmount > 0) {
            return this.tradeService.buyFromCityToShip(this.vessel, player, this.city, this.ware, maxAmount, Optional.of(this.maxBuyPrice), this.vessel.getCaptian(), this.retainCash);
        }
        return 0L;
    }

    public void setCity(ICity city) {
        this.city = city;
    }

    protected ICity getCity() {
        return this.city;
    }

    public void setWare(IWare ware) {
        this.ware = ware;
    }

    public IWare getWare() {
        return this.ware;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public INavigableVessel getVessel() {
        return this.vessel;
    }

    public void setMaxBuyPrice(int maxBuyPrice) {
        this.maxBuyPrice = maxBuyPrice;
    }

    protected int getMaxBuyPrice() {
        return this.maxBuyPrice;
    }

    public void setRetainCash(long retainCash) {
        this.retainCash = retainCash;
    }
}

