/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class TravelToTradeStep
implements ITradeStep {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(TravelToTradeStep.class);
    private ICity destinationCity;
    private INavigableVessel vessel;
    @Autowired
    @XStreamOmitField
    private SeafaringService seafaringService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;

    public boolean execute() {
        Preconditions.checkNotNull((Object)this.vessel, (Object)"Vessel assigned to trade step must not be null");
        Preconditions.checkNotNull((Object)this.destinationCity, (Object)"The destination city must not be null");
        if (this.vessel instanceof IConvoy) {
            IConvoy convoy = (IConvoy)this.vessel;
            if (convoy.isPublicConvoy()) {
                TimedTask task = new TimedTask(){
                    {
                        this.setExecutionTime(TravelToTradeStep.this.date.getCurrentDate().plusDays(5L));
                    }

                    public void run() {
                        TravelToTradeStep.this.seafaringService.travelBetweenCities(TravelToTradeStep.this.vessel, TravelToTradeStep.this.destinationCity);
                    }
                };
                this.taskList.add(task);
            } else {
                this.seafaringService.travelBetweenCities(this.vessel, this.destinationCity);
            }
        } else {
            this.seafaringService.travelBetweenCities(this.vessel, this.destinationCity);
        }
        LOGGER.debug("Ship {} ({})travels from {} to {}", new Object[]{this.vessel.getName(), this.vessel.getUuid(), this.vessel.getLocation(), this.destinationCity.getCoordinates()});
        return false;
    }

    public String toString() {
        return "TravelToTradeStep " + ((IPlayer)this.vessel.getOwner()).getUuid() + " to " + this.destinationCity.getName();
    }

    public void setDestinationCity(ICity destinationCity) {
        this.destinationCity = destinationCity;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }
}

