/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.event.data.PeriodicalTimeWeekEndUpdate;
import ch.sahits.game.graphic.image.IMapImageServiceFacade;
import ch.sahits.game.openpatrician.clientserverinterface.model.WeaponSlotCount;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PeopleFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.engine.sea.AStarHeuristicProvider;
import ch.sahits.game.openpatrician.engine.sea.ESeaFightType;
import ch.sahits.game.openpatrician.engine.sea.LocationTracker;
import ch.sahits.game.openpatrician.engine.sea.SeaFightContext;
import ch.sahits.game.openpatrician.engine.sea.SeaFightService;
import ch.sahits.game.openpatrician.engine.sea.SeafaringService;
import ch.sahits.game.openpatrician.event.data.GraphInitialisationComplete;
import ch.sahits.game.openpatrician.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.event.data.ShipArrivesAtDestinationEvent;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.data.ShipPositionUpdateEvent;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.NewPirateEvent;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.service.RandomNameLoader;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@DependentInitialisation(value=StartNewGameBean.class)
public class PirateEngine
extends AbstractEngine {
    private static final Logger log = LoggerFactory.getLogger(PirateEngine.class);
    @Autowired
    private Random rnd;
    @Autowired
    private SeaPiratesState piratesState;
    @Autowired
    private LocationTracker locationTracker;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    @Qualifier(value="syncServerClientEventBus")
    private EventBus syncServerClientEventBus;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private IMapImageServiceFacade mapService;
    @Autowired
    private SeafaringService seafaringService;
    @Autowired
    private ShipyardEngine shipyardEngine;
    @Autowired
    private MapService cityService;
    @Autowired
    private Date date;
    @Autowired
    private SeaFightService seaFightService;
    @Autowired
    private PeopleFactory peopleFactory;
    @Autowired
    private AStarHeuristicProvider aStarHeuristicProvider;
    @Autowired
    @Qualifier(value="schedulableServerThreadPool")
    private ScheduledExecutorService schedulableServerThreadPool;
    @Autowired
    private ShipService shipService;
    private boolean graphInitialized = false;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("pirate_firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("pirate_lastnames.properties");
    private static RandomNameLoader shipLoader = new RandomNameLoader("shipnames.properties");

    @PostConstruct
    private void initialize() {
        this.clientServerEventBus.register((Object)this);
        this.timerEventBus.register((Object)this);
        this.syncServerClientEventBus.register((Object)this);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                while (!PirateEngine.this.graphInitialized) {
                    Thread.yield();
                }
                String firstName = firstNameLoader.getRandomName();
                String lastName = lastNameLoader.getRandomName();
                IShip ship = PirateEngine.this.createInitialPiratesShip();
                ISeaPirate pirate = PirateEngine.this.peopleFactory.createNewPirate(firstName, lastName, (INavigableVessel)ship);
                ship.setOwner((IShipOwner)pirate);
                PirateEngine.this.piratesState.add(pirate);
            }
        };
        this.schedulableServerThreadPool.schedule(task, 10L, TimeUnit.SECONDS);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
        this.timerEventBus.unregister((Object)this);
        this.syncServerClientEventBus.unregister((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Collections.emptyList();
    }

    @Subscribe
    public void initializedGraph(GraphInitialisationComplete event) {
        this.graphInitialized = true;
    }

    @Subscribe
    public void handleNewPirate(NewPirateEvent pirateEvent) {
        IShip ship = (IShip)pirateEvent.getPirate().getShip();
        Point2D adjustedSource = this.aStarHeuristicProvider.findClosest(ship.getLocation());
        ship.setLocation(adjustedSource);
        this.selectDestination(pirateEvent.getPirate());
    }

    @Subscribe
    public void handleShipReachesDestination(ShipArrivesAtDestinationEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.handlePirateShip(vessel)) {
            int damageInv = vessel.getDamage();
            if (damageInv < 20) {
                this.selectDestination((ISeaPirate)vessel.getOwner());
            } else {
                this.sendForRepairs(vessel);
            }
        }
    }

    private void selectDestination(ISeaPirate pirate) {
        Point2D destination;
        Point2D shipPosition = pirate.getShip().getLocation();
        if (pirate instanceof INonFreeSeaPirate && ((INonFreeSeaPirate)pirate).roamingNearCity().isPresent()) {
            ICity city = (ICity)((INonFreeSeaPirate)pirate).roamingNearCity().get();
            destination = this.mapService.getRandomPointAtSeaNear(city.getCoordinates());
        } else {
            destination = this.mapService.getLocationAtOtherEndOfMap(shipPosition);
        }
        Point2D adjustedDestination = this.aStarHeuristicProvider.findClosest(destination);
        log.info("Adjust destination {} -> {}", (Object)destination, (Object)adjustedDestination);
        this.aStarHeuristicProvider.addTargetNodeToHeuristic(adjustedDestination);
        log.debug("Source point of pirate is {}, destination {}", (Object)shipPosition, (Object)destination);
        Preconditions.checkArgument((boolean)this.mapService.isOnSea((int)shipPosition.getX(), (int)shipPosition.getY()), (Object)("Start position of the ship is not on sea: " + shipPosition));
        Preconditions.checkArgument((boolean)this.mapService.isOnSea((int)adjustedDestination.getX(), (int)adjustedDestination.getY()), (Object)("The destination is not at sea: " + adjustedDestination));
        this.seafaringService.travelNotBetweenCities(pirate.getShip(), adjustedDestination);
    }

    @Subscribe
    public void handleShipPositionUpdate(ShipPositionUpdateEvent event) {
        List<INavigableVessel> visibleVessels;
        INavigableVessel vessel = event.getShip();
        if (this.handlePirateShip(vessel) && !(visibleVessels = this.locationTracker.getShipsInSegments(event.getToLocation(), 50)).isEmpty()) {
            int nbPirateShips = 1;
            if (vessel instanceof IShipGroup) {
                nbPirateShips = ((IShipGroup)vessel).getShips().size();
            }
            for (INavigableVessel visibleVessel : visibleVessels) {
                IShipOwner vissibleOwner = visibleVessel.getOwner();
                if (vissibleOwner instanceof ISeaPirate) continue;
                int nbOpponentShips = 1;
                if (visibleVessel instanceof IConvoy) {
                    nbOpponentShips = ((IConvoy)visibleVessel).getShips().size();
                }
                if (nbOpponentShips > nbPirateShips) continue;
                this.seaFightService.calculateOutcome(vessel, visibleVessel, new SeaFightContext(ESeaFightType.STANDARD));
                if (!(vissibleOwner instanceof IPlayer)) break;
                IPlayer owner = (IPlayer)vissibleOwner;
                owner.updateCrimialDrive(-1);
                break;
            }
        }
    }

    private void sendForRepairs(INavigableVessel vessel) {
        vessel.togglePirateFlag();
        ICity city = this.cityService.findNearestCity(vessel.getLocation());
        this.seafaringService.travelToCity(vessel, city);
    }

    @Subscribe
    public void handleRepairPirateShip(ShipEntersPortEvent event) {
        if (this.handlePirateShip(event.getShip())) {
            INavigableVessel vessel = event.getShip();
            ICity city = event.getCity();
            IShipyard shipyard = city.getCityState().getShipyardState();
            if (vessel instanceof IShip) {
                this.shipyardEngine.repairPirateShip(shipyard, (IShip)vessel);
            } else if (vessel instanceof IShipGroup) {
                this.shipyardEngine.repair(shipyard, (IShipGroup)vessel);
            } else {
                log.warn("Can only repair pirate ships and pirate ship groups.");
            }
        }
    }

    @Subscribe
    public void handleRepairFinished(RepairFinishedEvent event) {
        if (this.handlePirateShip(event.getShip())) {
            INavigableVessel vessel = event.getShip();
            Point2D destination = this.mapService.getRandomPointAtSeaNear(vessel.getLocation());
            this.seafaringService.travelFromCity(vessel, destination);
            vessel.togglePirateFlag();
        }
    }

    @Subscribe
    public void handleWeeklyUpdate(PeriodicalTimeWeekEndUpdate event) {
        if (this.piratesState.getFreePirates().isEmpty()) {
            IShip ship = this.createInitialPiratesShip();
            String firstName = firstNameLoader.getRandomName();
            String lastName = lastNameLoader.getRandomName();
            ISeaPirate pirate = this.peopleFactory.createNewPirate(firstName, lastName, (INavigableVessel)ship);
            ship.setOwner((IShipOwner)pirate);
            this.piratesState.add(pirate);
        }
    }

    private IShip createInitialPiratesShip() {
        int i;
        ISnaikka ship;
        int shipChoice = this.rnd.nextInt(4);
        switch (shipChoice) {
            case 0: {
                ship = this.shipFactory.createSnaikka(shipLoader.getRandomName(), EShipUpgrade.LEVEL1, 0);
                break;
            }
            case 1: {
                ship = this.shipFactory.createCrayer(shipLoader.getRandomName(), EShipUpgrade.LEVEL1, 0);
                break;
            }
            case 2: {
                ship = this.shipFactory.createCog(shipLoader.getRandomName(), EShipUpgrade.LEVEL1, 0);
                break;
            }
            case 3: {
                ship = this.shipFactory.createHolk(shipLoader.getRandomName(), EShipUpgrade.LEVEL1, 0);
                break;
            }
            default: {
                throw new RuntimeException("Should never get here");
            }
        }
        ship.setNumberOfSailors(30);
        for (int i2 = 0; i2 < 30; ++i2) {
            this.shipService.placeWeapon(EWeapon.HAND_WEAPON, (IShip)ship);
        }
        WeaponSlotCount slotCount = this.shipService.getWeaponSlotCount(ship.getWeaponSlots());
        int nbBigWeapons = slotCount.getNbLargeSlots() / 3;
        int nbSmallWeapons = (slotCount.getNbLargeSlots() * 2 + slotCount.getNbSmallSlots()) / 6;
        EWeapon bigWeaponType = this.getBigWeaponType();
        EWeapon smallWeaponType = this.getSmallWeaponType();
        for (i = 0; i < nbBigWeapons; ++i) {
            this.shipService.placeWeapon(bigWeaponType, (IShip)ship);
        }
        for (i = 0; i < nbSmallWeapons; ++i) {
            this.shipService.placeWeapon(smallWeaponType, (IShip)ship);
        }
        return ship;
    }

    private boolean handlePirateShip(INavigableVessel vessel) {
        return vessel.getPirateFlag() && !(vessel.getOwner() instanceof IPlayer);
    }

    private EWeapon getBigWeaponType() {
        int year = this.date.getCurrentDate().getYear();
        if (year <= 1333) {
            return EWeapon.BALLISTA_BIG;
        }
        if (year <= 1367) {
            return EWeapon.TREBUCHET_BIG;
        }
        return EWeapon.BOMBARD;
    }

    private EWeapon getSmallWeaponType() {
        int year = this.date.getCurrentDate().getYear();
        if (year <= 1333) {
            return EWeapon.BALLISTA_SMALL;
        }
        if (year <= 1367) {
            return EWeapon.TREBUCHET_SMALL;
        }
        return EWeapon.CANNON;
    }
}

