/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.openpatrician.clientserverinterface.model.WaitingTradeMissionWrapper;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.OrlegShipOutfittedEvent;
import ch.sahits.game.openpatrician.clientserverinterface.service.ConvoyService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class ConvoyRepairMission
extends WaitingTradeMissionWrapper {
    private IShip orleg;
    @ListType(value=IShip.class)
    private List<IShip> ships;
    private boolean publicConvoy;
    private IConvoy reformedConvoy;
    @ListType(value=IShip.class)
    private List<IShip> repairedShips = new ArrayList<IShip>();
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private ConvoyService convoyService;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;

    public ConvoyRepairMission(IShip orleg, List<IShip> convoyShips, boolean publicConvoy) {
        super(((IAIPlayer)orleg.getOwner()).getTradeMission((INavigableVessel)orleg));
        this.orleg = orleg;
        this.ships = convoyShips;
        this.publicConvoy = publicConvoy;
        for (IShip convoyShip : convoyShips) {
            IAIPlayer player = (IAIPlayer)convoyShip.getOwner();
            ITradeMissionData origMissionData = player.getTradeMission((INavigableVessel)convoyShip);
            player.setTradeMission((INavigableVessel)convoyShip, (ITradeMissionData)new WaitingTradeMissionWrapper(origMissionData));
        }
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void handleShipRepaired(RepairFinishedEvent event) {
        INavigableVessel vessel = event.getShip();
        if (vessel.equals(this.orleg) || this.ships.contains(vessel)) {
            IShip ship = (IShip)vessel;
            ICity city = (ICity)this.shipService.findCity((INavigableVessel)ship).get();
            IAIPlayer player = (IAIPlayer)ship.getOwner();
            if (ship.equals(this.orleg)) {
                Optional optOrleg = this.convoyService.outfitAsOrleg(ship, city);
                if (optOrleg.isPresent()) {
                    this.reformedConvoy = this.convoyService.create(this.orleg, this.publicConvoy);
                }
            } else {
                if (this.reformedConvoy != null) {
                    this.convoyService.join(this.reformedConvoy, ship);
                } else {
                    this.repairedShips.add(ship);
                }
                this.ships.remove(ship);
            }
            if (this.reformedConvoy != null) {
                this.checkConvoySendingOn(player);
            }
        }
    }

    private void checkConvoySendingOn(IAIPlayer player) {
        if (this.ships.isEmpty()) {
            for (IShip ship : this.reformedConvoy.getShips()) {
                ITradeMissionData tradeMissionData = ((WaitingTradeMissionWrapper)player.getTradeMission((INavigableVessel)ship)).getTradeMissionData();
                player.setTradeMission((INavigableVessel)ship, tradeMissionData);
            }
            this.clientServerEventBus.unregister((Object)this);
            ((IAITradeStrategy)player.getTradeStrategyType((INavigableVessel)this.reformedConvoy).getStrategy()).initializeTradeCycle(player, (INavigableVessel)this.reformedConvoy);
        }
    }

    @Subscribe
    public void handleShipFittedForOrleg(OrlegShipOutfittedEvent event) {
        if (event.getShip().equals(this.orleg)) {
            this.reformedConvoy = this.convoyService.create(this.orleg, this.publicConvoy);
            this.checkConvoySendingOn((IAIPlayer)this.reformedConvoy.getOwner());
        }
    }

    public IShip getOrleg() {
        return this.orleg;
    }

    public List<IShip> getShips() {
        return this.ships;
    }

    public boolean isPublicConvoy() {
        return this.publicConvoy;
    }
}

