/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.openpatrician.engine.sea.model.PirateActivityEntry;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class PirateActivity {
    private static final int NUMBER_OF_CACHED_DAYS = 60;
    @Autowired
    private Date date;
    @MapType(key=LocalDateTime.class, value=PirateActivityEntry.class)
    private Map<LocalDateTime, PirateActivityEntry> map = new HashMap<LocalDateTime, PirateActivityEntry>();

    public void add(PirateActivityEntry pirateActivity) {
        this.map.put(this.date.getCurrentDate(), pirateActivity);
    }

    private void clearCache() {
        LocalDateTime now = this.date.getCurrentDate();
        this.map.keySet().removeIf(next -> next.isBefore(now.minusDays(60L)));
    }

    public List<PirateActivityEntry> getPirateActivity() {
        this.clearCache();
        return new ArrayList<PirateActivityEntry>(this.map.values());
    }

    public int getObservationPeriodInDays() {
        return 60;
    }
}

