package ch.sahits.game.javafx.bindings;

import javafx.beans.binding.IntegerBinding;
/**
 * IntegerBinding that does not change its value. This binding can be used
 * where the resulting values are not to be bound.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 1, 2013
 *
 */
public class ConstantIntegerBinding extends IntegerBinding {
	private final int value;
	
	

	public ConstantIntegerBinding(int value) {
		super();
		this.value = value;
	}



	@Override
	protected int computeValue() {
		return value;
	}

}
