package ch.sahits.game.javafx.control;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.Font;

public class BaleAmountAlwaysVisible extends Group implements IApplicableStyle {
    private StringProperty amount;
    private static final Image img = new Image(BarrelAmount.class.getResourceAsStream("bale_icon.png"), 24, 24, true, true);

    public BaleAmountAlwaysVisible(final Font font) {
        amount = new SimpleStringProperty(this, "amount", "");

        final ImageView imageView = new ImageView(img);
        final Label text = new Label();
        text.setFont(font);
        text.textProperty().bind(amount);
        imageView.layoutXProperty().bind(text.widthProperty().add(3));

        getChildren().addAll(text, imageView);
    }
    public void setAmount(Integer amount) {
        this.amount.set(String.valueOf(amount));
    }
    public int getAmount() {
        return Integer.parseInt(amount.get());
    }
    public StringProperty amountProperty() {
        return amount;
    }

    @Override
    public void applyStyle(String style) {
        for (Node node : getChildren()) {
            if (node instanceof IApplicableStyle) {
                ((IApplicableStyle)node).applyStyle(style);
            } else {
                node.setStyle(style);
            }
        }
    }
}
