package ch.sahits.game.javafx.control;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import ch.sahits.game.javafx.bindings.StringToIntegerBinding;
import ch.sahits.game.javafx.bindings.ZeroAmountBooleanBinding;

public class BarrelAmount extends BarrelAmountAlwaysVisible {

	public BarrelAmount(final Font font) {
        super(font);
		IntegerProperty intAmount = new SimpleIntegerProperty();
		intAmount.bind(new StringToIntegerBinding(amountProperty()));
		visibleProperty().bind(new ZeroAmountBooleanBinding(intAmount));
	}
}
