package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.bindings.StringToIntegerBinding;
import ch.sahits.game.javafx.bindings.ZeroAmountBooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.text.Font;
/**
 * Coin price which is only visible when the amount is larger than zero.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 6, 2013
 *
 */
public class CoinPrice extends CoinPriceAlwaysVisible {

	public CoinPrice(final Font font) {
		super(font);

		IntegerProperty intAmount = new SimpleIntegerProperty();
		intAmount.bind(new StringToIntegerBinding(amountProperty()));
		visibleProperty().bind(new ZeroAmountBooleanBinding(intAmount));
	}
}
