package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.util.INoticeBoardFactory;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.scene.Group;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ScrollPane.ScrollBarPolicy;
import javafx.scene.text.Font;

import java.net.URL;
/**
 * Control representing the main menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 1, 2013
 *
 */
public abstract class NoticeBoard extends Group { // TODO aho Nov 3, 2013: listen to events and delegate to the facory
	// TODO aho Nov 14, 2013: make dis configruable
	private ReadOnlyObjectProperty<Font> font;
	
	protected final ScrollPaneContent contentContainer;
	protected INoticeBoardFactory noticeBoardFactory;

	public NoticeBoard() {
		setManaged(false);
        String cssFileName = NoticeBoard.class.getSimpleName()+".css";
		URL resource = NoticeBoard.class.getResource(cssFileName);
		getStylesheets().add(resource.toExternalForm());

		ScrollPane scrollPane = new ScrollPane();
		scrollPane.setLayoutX(20);
		scrollPane.setLayoutY(5);
		scrollPane.setMaxWidth(216);
		scrollPane.setMinWidth(216);
		scrollPane.setMaxHeight(233);
		scrollPane.setMinHeight(233);
		scrollPane.setHbarPolicy(ScrollBarPolicy.NEVER);
		scrollPane.setVbarPolicy(ScrollBarPolicy.AS_NEEDED);
        contentContainer = new ScrollPaneContent();
        scrollPane.setContent(contentContainer);
		getChildren().addAll(scrollPane);
	}

    /**
     * Set the factory for the notice board
     * @param noticeBoardFactory factory instance
     */
	public void setNoticeBoardFactory(INoticeBoardFactory noticeBoardFactory) {
		this.noticeBoardFactory = noticeBoardFactory;
	}
	public Font getFont() {
		return font.get();
	}
	public void setFont(final Font font) {
		if (this.font == null) {
			this.font = new ReadOnlyObjectPropertyBase<Font>() {

				@Override
				public Object getBean() {
					return NoticeBoard.this;
				}

				@Override
				public String getName() {
					return "font";
				}

				@Override
				public Font get() {
					return font;
				}
			};
	        contentContainer.fontProperty().bind(this.font);
		}
	}


	
}
