package ch.sahits.game.javafx.control;

import javafx.beans.property.*;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.text.Font;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
/**
 * Open patrician spinner class.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 * @param T type for the mapping.
 *
 */
public class OpenPatricianSpinner<T> extends Control {
    /** The display options */
	private final ListProperty<String> options;
    /** Mapping the options to additional data */
    private Map<String,T> optionsMap; // use generic type
	// // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
	private final ReadOnlyObjectProperty<Font> currentFont;
	
	private final IntegerProperty selectedIndex;
	
	public OpenPatricianSpinner() {
		this(Font.getDefault());
	}
	
	public OpenPatricianSpinner(final Font font) {
		options = new SimpleListProperty<>(this, "options", FXCollections.observableList(new ArrayList<String>()));
		currentFont = new ReadOnlyObjectPropertyBase<Font>() {

			@Override
			public Object getBean() {
				return this;
			}

			@Override
			public String getName() {
				return "currentFont";
			}

			@Override
			public Font get() {
				return font;
			}
		};
		selectedIndex = new SimpleIntegerProperty(this, "selectedIndex", -1);
		this.getStyleClass().add(this.getClass().getSimpleName());
	}

	@Override
	protected String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	public ListProperty<String> optionsProperty() {
		return options;
	}
	public ObservableList<String> getOptions() {
		return options.get();
	}
	public Font getFont() {
		return currentFont.get();
	}
	public IntegerProperty selectedIndexProperty() {
		return selectedIndex;
	}
	public int getSelectedIndex() {
		return selectedIndex.get();
	}
	
	public void incSelectedIndex() {
		if (selectedIndex.getValue() < getOptions().size() -1) {
			selectedIndex.set(getSelectedIndex()+1);
		}
	}
	public void decSelectedIndex() {
		if (selectedIndex.getValue() > 0) {
			selectedIndex.set(getSelectedIndex()-1);
		}
	}

    /**
     * Set the options with their mapping values.
     * @param optionsMap .
     */
    public void setOptionsMap(Map<String,T> optionsMap) {
        this.options.clear();
        this.options.setAll(optionsMap.keySet());
        this.optionsMap = optionsMap;

    }

    /**
     * Retrieve the mapping value for the selected index.
     * @return selected mapped value.
     */
    public T getSelectedValue() {
        String key = options.get(getSelectedIndex());
        return optionsMap.get(key);
    }
}
