package ch.sahits.game.javafx.control;



import javafx.scene.control.Control;



import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;

/**
 * The {@code PlaceHolder} class defines a rectangle
 * with the specified size and location.

 * <p>Example code: the following code creates a place holder.</p>
 *
<PRE>
import ch.sahits.game.javafx.control.*;

PlaceHolder r = new PlaceHolder();
r.setX(50);
r.setY(50);
r.setLocalWidth(200);
r.setLocalHeight(100);
</PRE>
 */
public class PlaceHolder extends Control {
    private final DoubleProperty x = new SimpleDoubleProperty(this, "x", 0.0);
    private final DoubleProperty y = new SimpleDoubleProperty(this, "y", 0.0);
    private final DoubleProperty localWidth = new SimpleDoubleProperty(this, "width", 0.0);
    private final DoubleProperty localHeight = new SimpleDoubleProperty(this, "height", 0.0);

    public PlaceHolder() {
        this.getStyleClass().add(this.getClass().getSimpleName());
    }
    @Override
    protected String getUserAgentStylesheet() {
        return getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css").toExternalForm();
    }
    
    public PlaceHolder(double width, double height) {
        this();
        this.localWidth.set(width);
        this.localHeight.set(height);
    }
    public PlaceHolder(double x, double y, double width, double height) {
        this(width, height);
        this.x.set(x);
        this.y.set(y);
    }

    private void initBinding() {

    }
    public double getX() {
        return x.get();
    }

    public void setX(double value) {
        x.set(value);
    }

    public DoubleProperty xProperty() {
        return x;
    }

    public double getY() {
        return y.get();
    }

    public void setY(double value) {
        y.set(value);
    }

    public DoubleProperty yProperty() {
        return y;
    }

    public double getLocalWidth() {
        return localWidth.get();
    }

    public void setLocalWidth(double value) {
        localWidth.set(value);
    }

    public DoubleProperty widthLocalProperty() {
        return localWidth;
    }

    public double getLocalHeight() {
        return localHeight.get();
    }

    public void setLocalHeight(double value) {
        localHeight.set(value);
    }

    public DoubleProperty heightLocalProperty() {
        return localHeight;
    }
    
}
