package ch.sahits.game.javafx.control;

import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

import java.util.Iterator;

/**
 * Content for the scroll pane
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 3, 2013
 *
 */
public class ScrollPaneContent extends VBox {

	// TODO aho Nov 14, 2013: make dis configruable
	private  ObjectProperty<Font> font;

    private Label title;

    public ScrollPaneContent() {
		this.font = new SimpleObjectProperty(this, "font", null);
        getStylesheets().add(getClass().getResource(getClass().getSimpleName()+".css").toExternalForm());
        title = new Label();
        title.fontProperty().bind(font);
        title.getStyleClass().add("scrollPaneContent-title");
        getChildren().add(title);
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }
    /**
     * Add a new entry to the content
     * @param label text of the entry
     * @param onMouseClick event that is executed upon selecting the entry
     * @param disabled flag detailing if the entry is disabled
     */
    public void addEntry(String label, EventHandler<? super MouseEvent> onMouseClick, boolean disabled, boolean active) {
        ScrollPaneEntry entry = new ScrollPaneEntry(font.get());
        entry.setText(label);
        if (active) {
        	entry.setActive();
        }
        entry.setOnMousePressed(onMouseClick);
        entry.addEventFilter(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

			@Override
			public void handle(MouseEvent event) {
				resetStyle();
				
			}});
        entry.setDisable(disabled);
        getChildren().addAll(entry);
    }
    /**
     * Reset the styles on all entries
     */
    public void resetStyle() {
        for (Node node : getChildren()) {
            if (node instanceof ScrollPaneEntry) {
                ((ScrollPaneEntry)node).resetStyle();
            }
        }
    }
    /**
     * Remove all the contents and clear the title
     */
    public void clearContents() {
    	title.setText("");
        Platform.runLater(new Runnable() {
            @Override
            public void run() {
                for (Iterator<Node> iterator = getChildren().iterator(); iterator.hasNext();) {
                    Node node = (Node) iterator.next();
                    if (node instanceof ScrollPaneEntry) {
                        iterator.remove();
                    }

                }
            }
        });
    }
    public ObjectProperty<Font> fontProperty() {
    	return font;
    }
}
