package ch.sahits.game.javafx.control;

import javafx.geometry.Dimension2D;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
/**
 * Utility class to define the dimensions of texts used with a certain font.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Aug 4, 2013
 *
 */
public class TextSizingUtility {

    double computeTextWidth(Font font, String text, double wrappingWidth) {
        Text helper = new Text();
        helper.setText(text);
        helper.setFont(font);
        // Note that the wrapping width needs to be set to zero before
        // getting the text's real preferred width.
        helper.setWrappingWidth(0);
        //helper.setLineSpacing(0); Only available with JavaFX 8
        double w = Math.min(helper.prefWidth(-1), wrappingWidth);
        helper.setWrappingWidth((int)Math.ceil(w));
        double textWidth = Math.ceil(helper.getLayoutBounds().getWidth());
		return textWidth;
    }

    double computeTextHeight(Font font, String text, double wrappingWidth) {
        return computeTextHeight(font, text, wrappingWidth, 0);
    }

    double computeTextHeight(Font font, String text, double wrappingWidth, double lineSpacing) {
        Text helper = new Text();
        helper.setText(text);
        helper.setFont(font);
        helper.setWrappingWidth((int)wrappingWidth);
        //helper.setLineSpacing(0); Only available with JavaFX 8
        return helper.getLayoutBounds().getHeight();
    }
    /**
     * Calculate the dimensions of a string using the font with the number of characters.
     * The height is the maximum value, the width is an average value.
     * @param size
     * @param font
     * @return
     */
	public Dimension2D calculate(int size, Font font) {
		double height = computeTextHeight(font, "Tg", Double.MAX_VALUE);
		double width = computeTextWidth(font, "n", Double.MAX_VALUE);
		Dimension2D dim = new Dimension2D(width*size*.8, height*1.2);
		return dim;
	}
    /**
     * Calculate the dimensions of a string using the font with the number of characters.
     * The height is the maximum value, the width is an average value.
     * @param size
     * @param font
     * @return
     */
	public Dimension2D calculate(String text, Font font) {
		double height = computeTextHeight(font, text, Double.MAX_VALUE);
		double width = computeTextWidth(font, text, Double.MAX_VALUE);
		Dimension2D dim = new Dimension2D(width, height*1.2);
		return dim;
	}

}