package ch.sahits.game.javafx.control.skin;

import java.io.InputStream;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import ch.sahits.game.javafx.control.ImageFactory;
import ch.sahits.game.javafx.control.OpenPatricianRadioButton;
import ch.sahits.game.javafx.control.TextSizingUtility;

import com.sun.javafx.scene.control.skin.SkinBase;
/**
 * Skin for the OpenPatrician radio button.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
public class OpenPatricianRadioButtonSkin extends
		SkinBase<OpenPatricianRadioButton, OpenPatricianRadioButtonBehavior> {
	
	private TextSizingUtility sizing = new TextSizingUtility();
	private ImageFactory imageFactory = new ImageFactory();

	public OpenPatricianRadioButtonSkin(final OpenPatricianRadioButton radioButton) {
		super(radioButton, new OpenPatricianRadioButtonBehavior(radioButton));
		String text = radioButton.getText();
		Dimension2D dim = sizing.calculate(text, radioButton.getCurrentFont());
		InputStream is = getClass().getResourceAsStream("radioboxbg.png");
		Image rbBG = new Image(is);
		ImageView radioButtonView = new ImageView(rbBG);
		double width = dim.getWidth();
		final int remainWidth = 28; // width that is left from the background
		final int destHight = 27;
		final double xStart = rbBG.getWidth();
		final int yStart = 0;
		double destWidth = width-remainWidth;
		
		String fileName = imageFactory.getFileNameExt(destWidth,destHight,remainWidth);
		is = getClass().getResourceAsStream(fileName);
		Image slab = new Image(is, destWidth, destHight, false, true);
		ImageView slabView = new ImageView(slab);
		slabView.translateXProperty().set(xStart);
		slabView.translateYProperty().set(yStart);
		
		Label label = new Label(text);
		label.getStyleClass().add("openPatricianRadioButton");
		double posX = destWidth/2+(xStart-remainWidth-10);
		label.translateXProperty().set(posX);
		
		final Label selectedLabel;
		if (radioButton.isSelected()) {
			selectedLabel = new Label(radioButton.getSelectedLabel());
		} else {
			selectedLabel = new Label(radioButton.getUnselectedLabel());
		}
		selectedLabel.getStyleClass().add("openPatricianRadioButton-selection");
		selectedLabel.translateXProperty().set(20);
		selectedLabel.translateYProperty().set(32);
		
		radioButton.selectedProperty().addListener(new ChangeListener<Boolean>() {

			@Override
			public void changed(ObservableValue<? extends Boolean> observable,
					Boolean oldValue, Boolean newValue) {
				if (newValue) {
					selectedLabel.setText(radioButton.getSelectedLabel());
				} else {
					selectedLabel.setText(radioButton.getUnselectedLabel());
				}
			}
		});
		
		Group background = new Group(radioButtonView, slabView, label, selectedLabel);
		
		background.setOnMouseReleased(new EventHandler<MouseEvent>() {
			
			@Override
			public void handle(MouseEvent arg0) {
				boolean oldValue = radioButton.selectedProperty().get();
				if (!oldValue) {
					radioButton.setSelected(!oldValue);
				}
			}
			
		});

		background.setManaged(false);
		
		getChildren().add(background);
		

	}

}
