package ch.sahits.game.javafx.control.skin;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import ch.sahits.game.javafx.control.ImageFactory;
import ch.sahits.game.javafx.control.OpenPatricianButton;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.TextSizingUtility;

import com.sun.javafx.scene.control.skin.SkinBase;
/**
 * Skin for the open patrician stone button.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
public class OpenPatricianStoneButtonSkin extends SkinBase<OpenPatricianStoneButton, OpenPatricianStoneButtonBehavior> {

	public OpenPatricianStoneButtonSkin(final OpenPatricianStoneButton button) {
		super(button, new OpenPatricianStoneButtonBehavior(button));
		
		
		Dimension2D dim = calculateButtonDimensions(button);
		ImageFactory imageFactory = new ImageFactory();
		Image img = imageFactory.getSlabImage(dim);
		final ImageView imageView = new ImageView(img);
		
		final Label label = new Label(button.getText()); 
		label.setFont(button.getFont());
		label.fontProperty().addListener(new ChangeListener<Font>() {

			@Override
			public void changed(ObservableValue<? extends Font> observable,
					Font oldValue, Font newValue) {
				Dimension2D dim = new TextSizingUtility().calculate(button.getText(), newValue);
				// add padding
				ImageFactory imageFactory = new ImageFactory();
				Image img = imageFactory.getSlabImage(dim);
				imageView.setImage(img);
			}
		});
		label.onMouseClickedProperty().bind(button.onActionProperty());
		imageView.onMouseReleasedProperty().bind(button.onActionProperty());
		button.textProperty().addListener(new ChangeListener<String>() {

			@Override
			public void changed(ObservableValue<? extends String> observable,
					String oldValue, String newValue) {
				Dimension2D dim = new TextSizingUtility().calculate(newValue, label.getFont());
				// add padding
				ImageFactory imageFactory = new ImageFactory();
				Image img = imageFactory.getSlabImage(dim);
				imageView.setImage(img);
			}
		});
		
		StackPane stack = new StackPane();
		stack.getChildren().addAll(imageView, label);
		Group group = new Group(stack);
		
		group.setManaged(false);
		
		getChildren().add(group);
	}

	private Dimension2D calculateButtonDimensions(
			final OpenPatricianButton button) {
		Dimension2D dim = new TextSizingUtility().calculate(button.getText(), button.getFont());
		return new Dimension2D(dim.getWidth()*1.2, dim.getHeight()*1.2);
	}

}
