package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.Prototype;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

/**
 * Table vell containing a dynamic text that needs to be bound.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 16, 2013
 *
 */
@Prototype
public class DynamicTextTableCell implements ITableCell {

	private final StringProperty value;
	
	public DynamicTextTableCell() {
		value = new SimpleStringProperty(this, "value", "");
	}

	public StringProperty valueProperty() {
		return value;
	}
	public void setValue(String value) {
		this.value.set(value);
	}
	public String getValue() {
		return value.get();
	}
	public void setValue(Integer value) {
		this.value.set(value.toString());
	}
}
