package ch.sahits.game.javafx.service;

import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 13, 2014
 */
public class MapSegmentImageFactory {
    @Autowired
    private Random rnd;

    private List<MapSegmentedImage> pirateHideOuts;
    private List<MapSegmentedImage> sunkShips;

    @PostConstruct
    private void initializeImages() {
        pirateHideOuts = new ArrayList<>();
        sunkShips = new ArrayList<>();
        pirateHideOuts.add(new MapSegmentedImage("MapSegment1"));
        pirateHideOuts.add( new MapSegmentedImage("MapSegment3"));

        sunkShips.add( new MapSegmentedImage("MapSegment2"));
        sunkShips.add( new MapSegmentedImage("MapSegment4"));
    }

    public MapSegmentedImage getRandomPirateNest() {
        return getRandomImage(pirateHideOuts);
    }
    public MapSegmentedImage getRandomTreasureNest() {
        return getRandomImage(sunkShips);
    }
    private MapSegmentedImage getRandomImage(List<MapSegmentedImage> imgList) {
        MapSegmentedImage img = imgList.get(rnd.nextInt(imgList.size()));
        int availableSegment = rnd.nextInt(9);
        img.addSegment(availableSegment);
        return img;
    }
}
