/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control.skin;

import ch.sahits.game.javafx.control.OpenPatricianSlider;
import ch.sahits.game.javafx.control.skin.OpenPatricianSliderSkin;
import java.util.ArrayList;
import javafx.geometry.Point2D;
import javafx.scene.text.Font;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class OpenPatricianSliderSkinTest {
    private OpenPatricianSliderSkin skin;

    @Before
    public void setUp() {
        Font font = Font.getDefault();
        OpenPatricianSlider slider = new OpenPatricianSlider(font, 200);
        ArrayList<String> values = new ArrayList<String>();
        values.add("value 1");
        values.add("value 2");
        values.add("value 3");
        slider.setValues(values);
        this.skin = new OpenPatricianSliderSkin(slider);
    }

    @Test
    public void testAngleBetween2Lines0() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(0.0, 10.0);
        Assert.assertEquals((double)0.0, (double)this.skin.angleBetween2Lines(center, point), (double)0.001);
    }

    @Test
    public void testAngleBetween2Lines45() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(5.0, 5.0);
        Assert.assertEquals((double)45.0, (double)this.skin.angleBetween2Lines(center, point), (double)0.001);
    }

    @Test
    public void testAngleBetween2Lines90() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(10.0, 0.0);
        Assert.assertEquals((double)90.0, (double)this.skin.angleBetween2Lines(center, point), (double)0.001);
    }

    @Test
    public void testAngleBetween2Lines135() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(15.0, 5.0);
        Assert.assertEquals((double)135.0, (double)this.skin.angleBetween2Lines(center, point), (double)0.001);
    }

    @Test
    public void shouldBeSlope0LeftToRight() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(0.0, 10.0);
        double slope = this.skin.calculateSlope(center, point);
        Assert.assertThat((Object)0.0, (Matcher)Matchers.closeTo((double)slope, (double)0.001));
    }

    @Test
    public void shouldBeSlope0RightToLeft() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(20.0, 10.0);
        double slope = this.skin.calculateSlope(center, point);
        Assert.assertThat((Object)0.0, (Matcher)Matchers.closeTo((double)slope, (double)0.001));
    }

    @Test
    public void shouldBeSlopeMinusOne() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(5.0, 5.0);
        double slope = this.skin.calculateSlope(center, point);
        Assert.assertEquals((double)-1.0, (double)slope, (double)0.001);
    }

    @Test
    public void shouldBeSlopeMinusOne2() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(15.0, 15.0);
        double slope = this.skin.calculateSlope(center, point);
        Assert.assertEquals((double)-1.0, (double)slope, (double)0.001);
    }

    @Test
    public void shouldBeSlopePlusOne() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(15.0, 5.0);
        double slope = this.skin.calculateSlope(center, point);
        Assert.assertEquals((double)1.0, (double)slope, (double)0.001);
    }

    @Test
    public void shouldBeSlopePlusOne2() {
        Point2D center = new Point2D(10.0, 10.0);
        Point2D point = new Point2D(5.0, 15.0);
        double slope = this.skin.calculateSlope(center, point);
        Assert.assertEquals((double)1.0, (double)slope, (double)0.001);
    }

    @Test
    public void testCalculateMoveFactorStart() {
        double factor = this.skin.calculateMoveFactor(0.0);
        Assert.assertEquals((double)0.0, (double)factor, (double)0.001);
    }

    @Test
    public void testCalculateMoveFactorMiddle() {
        double factor = this.skin.calculateMoveFactor(90.0);
        Assert.assertEquals((double)0.5, (double)factor, (double)0.001);
    }

    @Test
    public void testCalculateMoveFactorEnd() {
        double factor = this.skin.calculateMoveFactor(180.0);
        Assert.assertEquals((double)1.0, (double)factor, (double)0.001);
    }

    @Test
    public void testCalculateBasePoint0() {
        Point2D center = new Point2D(10.0, 10.0);
        double angle = 180.0;
        double radius = 10.0;
        Point2D point = this.skin.calculateBasePoint(center, radius, angle);
        Point2D expected = new Point2D(0.0, 10.0);
        Assert.assertEquals((Object)expected, (Object)point);
    }

    @Test
    public void testCalculateBasePoint90() {
        Point2D center = new Point2D(10.0, 10.0);
        double angle = 270.0;
        double radius = 10.0;
        Point2D point = this.skin.calculateBasePoint(center, radius, angle);
        Point2D expected = new Point2D(10.0, 0.0);
        Assert.assertEquals((Object)expected, (Object)point);
    }

    @Test
    public void testCalculateBasePoint180() {
        Point2D center = new Point2D(10.0, 10.0);
        double angle = 360.0;
        double radius = 10.0;
        Point2D point = this.skin.calculateBasePoint(center, radius, angle);
        Point2D expected = new Point2D(20.0, 10.0);
        Assert.assertEquals((Object)expected, (Object)point);
    }

    @Test
    public void testCalculateBasePoint45() {
        Point2D center = new Point2D(10.0, 10.0);
        double angle = 225.0;
        double radius = 10.0;
        Point2D point = this.skin.calculateBasePoint(center, radius, angle);
        Point2D expected = new Point2D((double)(10.0f - (float)Math.sqrt(50.0)), (double)(10.0f - (float)Math.sqrt(50.0)));
        Assert.assertEquals((Object)expected, (Object)point);
    }

    @Test
    public void testCalculateBasePoint135() {
        Point2D center = new Point2D(10.0, 10.0);
        double angle = 315.0;
        double radius = 10.0;
        Point2D point = this.skin.calculateBasePoint(center, radius, angle);
        Point2D expected = new Point2D((double)((float)Math.sqrt(50.0) + 10.0f), (double)(10.0f - (float)Math.sqrt(50.0)));
        Assert.assertEquals((Object)expected, (Object)point);
    }

    @Test
    public void testSnapToNearestAngle() {
        int angle;
        for (angle = 0; angle <= 50; ++angle) {
            this.skin.currentRotation.set((double)angle);
            this.skin.snapToNearestAngle();
            Assert.assertEquals((String)("Snapped to wrong angle at rotation " + angle), (double)10.0, (double)this.skin.currentRotation.get(), (double)0.001);
        }
        for (angle = 51; angle < 130; ++angle) {
            this.skin.currentRotation.set((double)angle);
            this.skin.snapToNearestAngle();
            Assert.assertEquals((String)("Snapped to wrong angle at rotation " + angle), (double)90.0, (double)this.skin.currentRotation.get(), (double)0.001);
        }
        for (angle = 131; angle < 180; ++angle) {
            this.skin.currentRotation.set((double)angle);
            this.skin.snapToNearestAngle();
            Assert.assertEquals((String)("Snapped to wrong angle at rotation " + angle), (double)170.0, (double)this.skin.currentRotation.get(), (double)0.001);
        }
    }
}

