package ch.sahits.game.javafx.bindings;

import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
/**
 * Boolean binding checking the amount of an integer property.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 2, 2013
 *
 */
public class ZeroAmountBooleanBinding extends BooleanBinding {
	
	private final IntegerProperty amountToBeChecked;
	

	public ZeroAmountBooleanBinding(IntegerProperty amountToBeChecked) {
		super();
		this.amountToBeChecked = amountToBeChecked;
		bind(amountToBeChecked);
	}

	/**
	 * Evaluates to true as long as the bound integer property is positive (>0).
	 */
	@Override
	protected boolean computeValue() {
		return amountToBeChecked.greaterThan(0).get();
	}

}
