package ch.sahits.game.javafx.control;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.SpriteAnimation;
import ch.sahits.game.graphic.image.SpriteAnimationFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IPlayer;
import javafx.animation.RotateTransition;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
/**
 * Status control displaying the city name, population, date and cash.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 2, 2013
 *
 */
public class GameStatus extends Group {
    private final Logger logger = Logger.getLogger(getClass());

	// // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
	private Text cashTxt;
	private Text dateTxt;
    @Autowired
    private Date gameDate;
    @Autowired
    private GameFactory gameFactory;

    @Autowired
    private SpriteAnimationFactory spriteAnimFactory;
    @Autowired
    @Qualifier("mainScreenXMLImageLoader")
    private IDataImageLoader imageLoader;

	public GameStatus() {
		setManaged(false);
        getStylesheets().add(getClass().getResource(getClass().getSimpleName()+".css").toExternalForm());
        cashTxt = new Text();
        dateTxt = new Text();

	}
    @PostConstruct
    private void initializeControl() {

        final Rectangle ph = new Rectangle(250, 50, Color.TRANSPARENT);
        final int spacing = 10;

        SimpleStringProperty date = new SimpleStringProperty(this, "date", "");
        try {
            bindDate(date);
        } catch (NullPointerException e) {
            try {
                Thread.sleep(50);
            } catch (InterruptedException e1) {
                logger.warn("Interrupped while waiting for date initialisation");
            }
            bindDate(date);
        }
        cashTxt.getStyleClass().addAll("Text");
        dateTxt.getStyleClass().addAll("Text");

        final ImageView cashPile = spriteAnimFactory.createImageViewForSprite("sprites/coin-pile");
        cashPile.setScaleY(0.5);
        cashPile.setScaleX(0.5);

        final ImageView time = new ImageView(imageLoader.getImage("icons/64/hourglass"));
        time.setScaleX(0.5);
        time.setScaleY(0.5);
        time.setOnMouseReleased(new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                IGame game = gameFactory.getGame();
                game.fastForward();
            }
        });

        cashPile.setLayoutY(-14);
        cashTxt.setLayoutX(cashPile.getLayoutX() + 38 + spacing);
        cashTxt.setTextOrigin(VPos.BASELINE);
        cashTxt.setLayoutY(30);
        cashTxt.textProperty().addListener(new ChangeListener<String>() {
            @Override
            public void changed(ObservableValue<? extends String> observableValue, String s, String t1) {
                SpriteAnimation animation = spriteAnimFactory.createAnimation(cashPile, "sprites/coin-pile", true);
                animation.play();
            }
        });

        time.setLayoutY(-8);
        time.setLayoutX(ph.getWidth() - spacing - 32);
        TransparentImageViewClickableArea fastForwardArea = new TransparentImageViewClickableArea(time);
        dateTxt.setLayoutX(time.getLayoutX() - spacing - dateTxt.getBoundsInLocal().getWidth());
        dateTxt.setTextOrigin(VPos.BASELINE);
        dateTxt.setLayoutY(30);
        dateTxt.boundsInLocalProperty().addListener(new ChangeListener<Bounds>() {
            @Override
            public void changed(ObservableValue<? extends Bounds> observableValue, Bounds oldBounds, Bounds newBounds) {
                if (oldBounds.getWidth() != newBounds.getWidth()) {
                    dateTxt.setLayoutX(time.getLayoutX() - spacing - newBounds.getWidth());
                }
            }
        });
        dateTxt.textProperty().bind(date);
        dateTxt.textProperty().addListener(new ChangeListener<String>() {
            @Override
            public void changed(ObservableValue<? extends String> observableValue, String s, String t1) {
                RotateTransition rotation = new RotateTransition(Duration.millis(1200), time);
                rotation.setByAngle(-360.0);
                rotation.setCycleCount(1);
                rotation.setAutoReverse(false);

                rotation.play();
            }
        });

        getChildren().addAll(ph, cashPile, cashTxt, dateTxt, time, fastForwardArea);

//        HBox cashBox = new HBox(5);
//        ImageView cashPile = spriteAnimFactory.createImageViewForSprite("sprites/coin-pile");
//        cashPile.setLayoutX(-64);
//        cashPile.setScaleX(0.5);
//        cashPile.setScaleY(0.5);
//        cashTxt.setFill(Color.WHITE);
//        cashTxt.getStyleClass().add("Text");
//        cashBox.getChildren().addAll(cashPile, cashTxt);
//
//        dateTxt.setFill(Color.WHITE);
//        dateTxt.getStyleClass().add("Text");
//        dateTxt.textProperty().bind(date);
//
//        Rectangle placeholder = new Rectangle(250, 50);
//        placeholder.setFill(Color.TRANSPARENT);
//        AnchorPane anchorPane = new AnchorPane();
//        anchorPane.getChildren().addAll(cashPile, cashTxt, dateTxt);
//        anchorPane.setPrefWidth(250);
//        AnchorPane.setLeftAnchor(cashPile, 20.0);
//        AnchorPane.setLeftAnchor(cashTxt, 20.0 + 64 + 5);
//        AnchorPane.setRightAnchor(dateTxt, 5.0);
//        getChildren().addAll(anchorPane);

    }

    private void bindDate(SimpleStringProperty date) {
        date.bind(gameDate.dayDateBinding());
    }

    public void bindToPlayer(IPlayer player) {
        cashTxt.textProperty().bind(player.getCompany().cashProperty().asString());
    }

	
	public void setFont(Font f) {
		cashTxt.setFont(f);
		dateTxt.setFont(f);
	}

}
