package ch.sahits.game.javafx.control;
/**
 * Model fo a line to be rendered in pagination.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Aug 7, 2013
 *
 */
public class Line {

	private String line;
	private String styleClass;
	public String getLine() {
		return line;
	}
	public void setLine(String line) {
		this.line = line;
	}
	public String getStyleClass() {
		return styleClass;
	}
	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}
	@Override
	public String toString() {
		return line + ": " + styleClass;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((line == null) ? 0 : line.hashCode());
		result = prime * result
				+ ((styleClass == null) ? 0 : styleClass.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Line other = (Line) obj;
		if (line == null) {
			if (other.line != null)
				return false;
		} else if (!line.equals(other.line))
			return false;
		if (styleClass == null) {
			if (other.styleClass != null)
				return false;
		} else if (!styleClass.equals(other.styleClass))
			return false;
		return true;
	}
	
}
