package ch.sahits.game.javafx.control;

import javafx.beans.property.*;
import javafx.scene.control.Control;
import javafx.scene.text.Font;

import java.net.URL;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 16, 2013
 */
public class OpenPatricianDialogInput extends Control {

    private final StringProperty text;
    private final IntegerProperty size;
    // // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
    private final ReadOnlyObjectProperty<Font> currentFont;

    public OpenPatricianDialogInput() {
        this("", Font.getDefault());
    }
    public OpenPatricianDialogInput(String text) {
        this(text, Font.getDefault());
    }
    public OpenPatricianDialogInput(Font font) {
        this("", font);
    }
    /**
     * Initialize the initial text.
     * @param text
     */
    public OpenPatricianDialogInput(String text, final Font font) {
        super();
        this.text = new SimpleStringProperty(this, "text", text);
        size = new SimpleIntegerProperty(this, "size", 25);
        currentFont = new ReadOnlyObjectPropertyBase<Font>() {

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "currentFont";
            }

            @Override
            public Font get() {
                return font;
            }
        };
        this.getStyleClass().add(this.getClass().getSimpleName());
    }


    @Override
    protected String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
        return cssURL.toExternalForm();
    }
    public StringProperty textProperty() {
        return text;
    }
    public String getText() {
        return text.get();
    }
    public void setText(String text) {
        this.text.set(text);
    }
    public IntegerProperty sizeProperty() {
        return size;
    }
    public void setSize(int size) {
        this.size.set(size);
    }
    public int getSize() {
        return size.get();
    }
    public Font getFont() {
        return currentFont.get();
    }
}
