package ch.sahits.game.javafx.control;

import java.net.URL;

import javafx.scene.Node;
import javafx.scene.control.Label;
/**
 * OpenPatrician styled Label.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 20, 2013
 *
 */
public class OpenPatricianLabel extends Label {

	public OpenPatricianLabel() {
		super();
		initializeStyle();
	}

	private void initializeStyle() {
		Class<? extends OpenPatricianLabel> clazz = this.getClass();
		URL cssURL = clazz.getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		getStylesheets().add(cssURL.toExternalForm());
		getStyleClass().add("openPatricianLabel");
	}

	public OpenPatricianLabel(String arg0, Node arg1) {
		super(arg0, arg1);
		initializeStyle();
	}

	public OpenPatricianLabel(String arg0) {
		super(arg0);
		initializeStyle();
	}

}
