package ch.sahits.game.javafx.control;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.text.Font;

public class OpenPatricianSlider extends Control {

	private final ObservableList<String> values;
	// // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
	private final ReadOnlyObjectProperty<Font> currentFont;
	
	private final IntegerProperty selectedIndex;
	private final ReadOnlyIntegerProperty initialWidth;

	public OpenPatricianSlider(int width) {
		this(Font.getDefault(), width);
	}
	
	public OpenPatricianSlider(final Font font, int width) {
		values = new SimpleListProperty<>(this, "options", FXCollections.observableList(new ArrayList<String>()));
		currentFont = new ReadOnlyObjectPropertyBase<Font>() {

			@Override
			public Object getBean() {
				return this;
			}

			@Override
			public String getName() {
				return "currentFont";
			}

			@Override
			public Font get() {
				return font;
			}
		};
		initialWidth = new SimpleIntegerProperty(this,"initialWidth", width);
		selectedIndex = new SimpleIntegerProperty(this, "selectedIndex", -1);
		
		this.getStyleClass().add(this.getClass().getSimpleName());
	}

	@Override
	protected String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}

	public ObservableList<String> valuesProperty() {
		return values;
	}
	public void setValues(List<String> options) {
		this.values.setAll(options);
		this.selectedIndex.set(0);
	}
	public void setValues(String... options) {
		this.values.setAll(options);
		this.selectedIndex.set(0);
	}
	
	public String getSelectedValue() {
		return values.get(getSelectedIndex());
	}
	
	public Font getFont() {
		return currentFont.get();
	}
	public IntegerProperty selectedIndexProperty() {
		return selectedIndex;
	}
	public int getSelectedIndex() {
		return selectedIndex.get();
	}
	
	public int getInitialWidth() {
		return initialWidth.get();
	}

}
