package ch.sahits.game.javafx.control;

import java.net.URL;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.text.Font;
/**
 * Open patrician wood input field.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Sep 23, 2013
 *
 */
public class OpenPatricianWoodenTextInput extends Control {
	
	private final StringProperty text;
	private final IntegerProperty size;
	// // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
	private final ReadOnlyObjectProperty<Font> currentFont;

	public OpenPatricianWoodenTextInput() {
		this("", Font.getDefault());
	}
	public OpenPatricianWoodenTextInput(String text) {
		this(text, Font.getDefault());
	}
	public OpenPatricianWoodenTextInput(Font font) {
		this("", font);
	}
	/**
	 * Initialize the initial text.
	 * @param text
	 */
	public OpenPatricianWoodenTextInput(String text, final Font font) {
		super();
		this.text = new SimpleStringProperty(this, "text", text);
		size = new SimpleIntegerProperty(this, "size", 25);
		currentFont = new ReadOnlyObjectPropertyBase<Font>() {

				@Override
				public Object getBean() {
					return this;
				}

				@Override
				public String getName() {
					return "currentFont";
				}

				@Override
				public Font get() {
					return font;
				}
			};
		this.getStyleClass().add(this.getClass().getSimpleName());
	}
	
	
	@Override
	protected String getUserAgentStylesheet() {
        URL cssURL = getClass().getResource("/ch/sahits/game/javafx/control/"+getClass().getSimpleName()+".css");
		return cssURL.toExternalForm();
	}
	public StringProperty textProperty() {
		return text;
	}
	public String getText() {
		return text.get();
	}
	public void setText(String text) {
		this.text.set(text);
	}
	public IntegerProperty sizeProperty() {
		return size;
	}
	public void setSize(int size) {
		this.size.set(size);
	}
	public int getSize() {
		return size.get();
	}
	public Font getFont() {
		return currentFont.get();
	}

}
