package ch.sahits.game.javafx.control;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Group;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
/**
 * Status control displaying the city name.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 2, 2013
 *
 */
public class ViewStatus extends Group {
	
	private StringProperty city;
	private DoubleProperty width;
	// // TODO aho Sep 21, 2013: replace with stylable with JavaFX 8
	private Text cityName;
	
	public ViewStatus() {
		setManaged(false);
        getStylesheets().add(getClass().getResource(getClass().getSimpleName()+".css").toExternalForm());
		city = new SimpleStringProperty(this, "city", "");
		width = new SimpleDoubleProperty(this, "controlWidth", 0);
		cityName = new Text();
		cityName.setFill(Color.WHITE);
		cityName.getStyleClass().add("cityName");
		cityName.textProperty().bind(city);
		Rectangle placeholder = new Rectangle(width.doubleValue(), 50);
		placeholder.setFill(Color.TRANSPARENT);
		placeholder.widthProperty().bind(width);
		StackPane centering = new StackPane();
		centering.prefWidthProperty().bind(width);
		centering.getChildren().add(cityName);
		getChildren().addAll(placeholder, centering);
	}


	public void setCity(String city) {
		this.city.set(city);
	}
	public String getCity() {
		return this.city.get();
	}
	
	public StringProperty cityProperty() {
		return city;
	}
	
	public DoubleProperty widthProperty() {
		return width;
	}
	
	public void setWidth(double width) {
		this.width.set(width);
	}
	public double getWidth() {
		return width.doubleValue();
	}
	public void setFont(Font f) {
		cityName.setFont(f);
	}

}
