package ch.sahits.game.javafx.control.skin;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import ch.sahits.game.javafx.control.OpenPatricianDialogInput;
import ch.sahits.game.javafx.control.TextSizingUtility;

import com.sun.javafx.scene.control.skin.SkinBase;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 16, 2013
 */
public class OpenPatricianDialogInputSkin extends SkinBase<OpenPatricianDialogInput, OpenPatricianDialogInputBehavior> {

    private DoubleProperty width = new SimpleDoubleProperty(this, "width", 0);
    private DoubleProperty height = new SimpleDoubleProperty(this, "height", 0);
    private ObjectProperty<Font> currentFont;

    private TextSizingUtility sizing = new TextSizingUtility();

    public OpenPatricianDialogInputSkin(OpenPatricianDialogInput input) {
        super(input, new OpenPatricianDialogInputBehavior(input));



        currentFont = new SimpleObjectProperty<Font>(this, "currentFont", input.getFont());
        Dimension2D dim = sizing.calculate(input.getSize(), currentFont.get());
        width.set(dim.getWidth());
        height.set(dim.getHeight() + 10);

        final TextField textField = new TextField(input.getText());
        textField.textProperty().bindBidirectional(input.textProperty());
        textField.getStyleClass().add("openPatricianDialogInput");
        textField.setMaxSize(width.doubleValue(), height.doubleValue());

        Rectangle background = new Rectangle();
        background.setHeight(height.doubleValue());
        background.setWidth(width.doubleValue());
        background.setFill(Color.rgb(150, 150, 150));



        StackPane stack = new StackPane();
        stack.getChildren().addAll(background, textField);
        Group group = new Group(stack);
        group.setManaged(false);

        getChildren().add(group);
    }
}
