package ch.sahits.game.javafx.layout;

import java.util.List;

import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
/**
 * Layout that ensures that the children are always laied out to be in the bottom right corner.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jul 14, 2013
 *
 */
public class AnchoredBottomRightLayout extends AnchorPane {

	@Override
	protected void layoutChildren() {
        List<Node> managed = getManagedChildren();
        double width = getWidth();
        double height = getHeight();
        
        for (int i = 0; i < managed.size(); i++) {
            Node child = managed.get(i);
            Bounds bounds = child.getBoundsInParent();
            double left = Math.max(width - bounds.getWidth(), 0);
            double top = Math.max(height - bounds.getHeight(), 0);

            Pos childAlignment = Pos.BASELINE_RIGHT;
            // TODO consider translation of the child
            layoutInArea(child, left, top,
                           bounds.getWidth(), bounds.getHeight(),
                           child.getBaselineOffset(), getInsets(),
                           childAlignment.getHpos(),
                           childAlignment.getVpos());
        }
	}


}
