package ch.sahits.game.javafx.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableRow implements Iterable<ITableCell>{

	private List<ITableCell> cells;
	private Map<ITableCell,ECellConstraint> contraints;
	public TableRow() {
		cells = new ArrayList<>();
		contraints = new HashMap<>();
	}
	public ITableCell get(int index) {
		return cells.get(index);
	}
	public int size() {
		return cells.size();
	}
	public void add(ITableCell cell) {
		cells.add(cell);
	}
	public void add(ITableCell cell, ECellConstraint contraint) {
		add(cell);
		contraints.put(cell, contraint);
	}
	@Override
	public Iterator<ITableCell> iterator() {
		return cells.iterator();
	}
	
	public boolean hasConstraint(ITableCell cell) {
		return contraints.containsKey(cell);
	}
	public ECellConstraint getCellConstraint(ITableCell cell) {
		return contraints.get(cell);
	}

}
