package ch.sahits.game.javafx.util;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

import org.springframework.stereotype.Component;


/**
 * Utility class providing a stage which displayes the dones of a scene and their CSS styles.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Aug 11, 2013
 *
 */
@Component
public class SceneCSSExplorer {
	
	private Label styleInfo;

	
	public void explore(Scene scene) {
		Stage stage = new Stage();
		SplitPane splitPane = new SplitPane();
		TreeNodeItem rootNode = new TreeNodeItem("Scene");
		VBox vBox = new VBox();
		Label title = new Label("Scene graph style infor");
		styleInfo = new Label();
		vBox.getChildren().addAll(title, styleInfo);
		ObservableList<Node> nodes = scene.getRoot().getChildrenUnmodifiable();
		for (Node node : nodes) {
			TreeNodeItem item = new TreeNodeItem(node);
			rootNode.getChildren().add(item);
			
		}
		TreeView<String> sceneGraph = new TreeView<String>(rootNode);
		sceneGraph.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);  
		sceneGraph.getSelectionModel().selectedItemProperty().addListener(new TreeItemSelectionListener());
		splitPane.getItems().addAll(sceneGraph, vBox);
		Scene localeScene = new Scene(splitPane);
		stage.setScene(localeScene);
		stage.show();
	}
	
	private class TreeItemSelectionListener implements ChangeListener<TreeItem<String>> {

		@Override
		public void changed(ObservableValue<? extends TreeItem<String>> observable,
				TreeItem<String> oldValue, TreeItem<String> newValue) {
			Node node = ((TreeNodeItem)newValue).getBackingNode();
			if (node != null) {
				String style = node.getStyle();
				styleInfo.setText(style);
			} else {
				styleInfo.setText("");

			}
		}
		
	}
	
}
