/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.javafx.control.IWordSplitter;
import ch.sahits.game.javafx.control.Line;
import ch.sahits.game.javafx.control.NonAlphaNumWordSplitter;
import ch.sahits.game.javafx.control.Page;
import ch.sahits.game.javafx.control.PageSplitter;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.util.model.Heading;
import ch.sahits.game.openpatrician.util.model.ITextComponent;
import ch.sahits.game.openpatrician.util.model.Paragraph;
import ch.sahits.game.openpatrician.util.model.Text;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.text.Font;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PageSplitterTest {
    @Test
    public void shouldApplyPropperStyles() {
        Font font = Font.getDefault();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addHeading(new Heading("heading"));
        text.addParagraph(new Paragraph("contents"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "heading", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "heading", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "contents", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "contents", Double.MAX_VALUE)).willReturn((Object)10.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)1L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)2L, (long)page.getLines().size());
        Assert.assertEquals((Object)"pagination-heading", (Object)((Line)page.getLines().get(0)).getStyleClass());
        Assert.assertEquals((Object)"pagination-paragraph", (Object)((Line)page.getLines().get(1)).getStyleClass());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldHandleUnknownTextComponent() {
        Font font = Font.getDefault();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = (Text)Mockito.mock(Text.class);
        ArrayList<1> components = new ArrayList<1>();
        components.add(new ITextComponent(){});
        BDDMockito.given((Object)text.getText()).willReturn(components);
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        splitter.splitIntoPages(text);
    }

    @Test
    public void shouldWrappAtLineLength() {
        Font font = Font.getDefault();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addParagraph(new Paragraph("Text with some words"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with", Double.MAX_VALUE)).willReturn((Object)50.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)75.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some words", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some words", Double.MAX_VALUE)).willReturn((Object)50.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)1L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)2L, (long)page.getLines().size());
        Assert.assertEquals((Object)"Text with", (Object)((Line)page.getLines().get(0)).getLine());
        Assert.assertEquals((Object)"some words", (Object)((Line)page.getLines().get(1)).getLine());
    }

    @Test
    public void shouldTrimLines() {
        Font font = Font.getDefault();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addParagraph(new Paragraph("Text with some words"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with", Double.MAX_VALUE)).willReturn((Object)50.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)75.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some words", Double.MAX_VALUE)).willReturn((Object)10.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some words", Double.MAX_VALUE)).willReturn((Object)50.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)1L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)2L, (long)page.getLines().size());
        Assert.assertEquals((Object)((Line)page.getLines().get(0)).getLine().trim(), (Object)((Line)page.getLines().get(0)).getLine());
        Assert.assertEquals((Object)((Line)page.getLines().get(1)).getLine().trim(), (Object)((Line)page.getLines().get(1)).getLine());
    }

    @Test
    public void shouldSplitOnMultiplePages() {
        Font font = Font.getDefault();
        PageSplitter splitter = new PageSplitter(100.0, 50.0, 0.0, 0.0, font);
        splitter.setWordSplitter((IWordSplitter)new NonAlphaNumWordSplitter());
        Text text = new Text();
        text.addParagraph(new Paragraph("Text with some words"));
        TextSizingUtility sizing = (TextSizingUtility)Mockito.mock(TextSizingUtility.class);
        splitter.overrideTextSizingUtility(sizing);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with", Double.MAX_VALUE)).willReturn((Object)50.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "Text with some", Double.MAX_VALUE)).willReturn((Object)75.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some", Double.MAX_VALUE)).willReturn((Object)25.0);
        BDDMockito.given((Object)sizing.computeTextHeight(font, "some words", Double.MAX_VALUE)).willReturn((Object)60.0);
        BDDMockito.given((Object)sizing.computeTextWidth(font, "some words", Double.MAX_VALUE)).willReturn((Object)50.0);
        List pages = splitter.splitIntoPages(text);
        Assert.assertEquals((long)2L, (long)pages.size());
        Page page = (Page)pages.get(0);
        Assert.assertEquals((long)1L, (long)page.getLines().size());
        Assert.assertEquals((Object)"Text with", (Object)((Line)page.getLines().get(0)).getLine());
        page = (Page)pages.get(1);
        Assert.assertEquals((long)1L, (long)page.getLines().size());
        Assert.assertEquals((Object)"some words", (Object)((Line)page.getLines().get(0)).getLine());
    }
}

